/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.LabelFeatures;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.Ping;
import at.mrdevelopment.esl.wireless.RxMetrics;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class LabelStatusInfo {
    static ESLLogger logger = ESLLogger.getLogger(LabelStatusInfo.class);
    private final Address labelAddress;
    private final WakeupStatistic wakeupStatistic;
    private final LabelFeatures labelFeatures;
    private final boolean pingPending;
    private final boolean joinPending;
    private final boolean eventConfirmPending;
    private final boolean setKeyPending;
    private final DateTime lastPingRequestTime;
    private final DateTime lastJoinRequestTime;
    private final DateTime lastSetKeyTime;
    private final DateTime lastJoinCommitTime;

    public LabelStatusInfo(Address labelAddress, int accessPointId) {
        this(labelAddress, new WakeupStatistic(labelAddress, accessPointId), LabelFeatures.BASIC_PROTOCOL, false, false, false, false, null, null, null, null);
    }

    public LabelStatusInfo(Address labelAddress, WakeupStatistic wakeupStatistic, LabelFeatures labelFeatures, boolean pingPending, boolean joinPending, boolean eventConfirmPending, boolean setKeyPending, DateTime lastPingRequestTime, DateTime lastJoinRequestTime, DateTime lastSetKeyTime, DateTime lastJoinCommitTime) {
        this.labelAddress = labelAddress;
        this.wakeupStatistic = wakeupStatistic;
        this.labelFeatures = labelFeatures;
        this.pingPending = pingPending;
        this.joinPending = joinPending;
        this.eventConfirmPending = eventConfirmPending;
        this.setKeyPending = setKeyPending;
        this.lastPingRequestTime = lastPingRequestTime;
        this.lastJoinRequestTime = lastJoinRequestTime;
        this.lastSetKeyTime = lastSetKeyTime;
        this.lastJoinCommitTime = lastJoinCommitTime;
    }

    public LabelStatusInfo pingRequestScheduled(DateTime pingRequestTime) {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, true, this.joinPending, this.eventConfirmPending, this.setKeyPending, pingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo processPing(Ping ping, RxMetrics rxMetrics) {
        WakeupStatistic newWakeupStatistic = this.wakeupStatistic.processPing(ping, rxMetrics);
        LabelFeatures newLabelFeatures = LabelFeatures.forFirmwareVersion(ping.getFirmwareVersion());
        if (logger.isDebugEnabled() && this.labelFeatures != newLabelFeatures) {
            logger.debug("Setting non-basic label features for label %s: %s", new Object[]{this.labelAddress, this.labelFeatures});
        }
        return new LabelStatusInfo(this.labelAddress, newWakeupStatistic, newLabelFeatures, false, this.joinPending, this.eventConfirmPending, this.setKeyPending, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo joinRequested(DateTime joinRequestTime) {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, true, this.eventConfirmPending, this.setKeyPending, this.lastPingRequestTime, joinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo joinCommitted(DateTime joinCommitTime) {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, false, this.eventConfirmPending, this.setKeyPending, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, joinCommitTime);
    }

    public LabelStatusInfo pingFailed() {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, false, this.joinPending, this.eventConfirmPending, this.setKeyPending, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo joinFailed() {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, false, this.eventConfirmPending, this.setKeyPending, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo eventReceived() {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, this.joinPending, true, this.setKeyPending, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo eventCommitted() {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, this.joinPending, false, this.setKeyPending, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo eventFailed() {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, this.joinPending, false, this.setKeyPending, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo setKeyScheduled() {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, this.joinPending, this.eventConfirmPending, true, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo setKeyCommitted(DateTime setKeyCommitTime) {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, this.joinPending, this.eventConfirmPending, false, this.lastPingRequestTime, this.lastJoinRequestTime, setKeyCommitTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo setKeyFailed(DateTime setKeyFailTime) {
        return new LabelStatusInfo(this.labelAddress, this.wakeupStatistic, this.labelFeatures, this.pingPending, this.joinPending, this.eventConfirmPending, false, this.lastPingRequestTime, this.lastJoinRequestTime, setKeyFailTime, this.lastJoinCommitTime);
    }

    public LabelStatusInfo markKeyUnset(boolean keyUnset) {
        WakeupStatistic newWakeupStatistic = this.wakeupStatistic.markKeyUnset(keyUnset);
        return new LabelStatusInfo(this.labelAddress, newWakeupStatistic, this.labelFeatures, this.pingPending, this.joinPending, this.eventConfirmPending, this.setKeyPending, this.lastPingRequestTime, this.lastJoinRequestTime, this.lastSetKeyTime, this.lastJoinCommitTime);
    }

    public Address getLabelAddress() {
        return this.labelAddress;
    }

    public WakeupStatistic getWakeupStatistic() {
        return this.wakeupStatistic;
    }

    public LabelFeatures getLabelFeatures() {
        return this.labelFeatures;
    }

    public boolean isPingPending() {
        return this.pingPending;
    }

    public boolean isJoinPending() {
        return this.joinPending;
    }

    public boolean isEventConfirmPending() {
        return this.eventConfirmPending;
    }

    public boolean isSetKeyPending() {
        return this.setKeyPending;
    }

    public boolean useSecurity() {
        return this.labelFeatures.isSecuritySupported() && !this.wakeupStatistic.isKeyUnset();
    }

    public boolean isKeyUnset() {
        return this.wakeupStatistic.isKeyUnset();
    }

    public Minutes getMinutesSinceLastPingRequest(DateTime now) {
        return this.lastPingRequestTime != null ? Minutes.minutesBetween((ReadableInstant)this.lastPingRequestTime, (ReadableInstant)now) : Minutes.MAX_VALUE;
    }

    public Minutes getMinutesSinceLastPingReply(DateTime now) {
        return this.wakeupStatistic.getMinutesSinceLastPingReply(now);
    }

    public Minutes getMinutesSinceLastJoinRequest(DateTime now) {
        return this.lastJoinRequestTime != null ? Minutes.minutesBetween((ReadableInstant)this.lastJoinRequestTime, (ReadableInstant)now) : Minutes.MAX_VALUE;
    }

    public Minutes getMinutesSinceLastJoinCommit(DateTime now) {
        return this.lastJoinCommitTime != null ? Minutes.minutesBetween((ReadableInstant)this.lastJoinCommitTime, (ReadableInstant)now) : Minutes.MAX_VALUE;
    }

    public Minutes getMinutesSinceLastSetKey(DateTime now) {
        return this.lastSetKeyTime != null ? Minutes.minutesBetween((ReadableInstant)this.lastSetKeyTime, (ReadableInstant)now) : Minutes.MAX_VALUE;
    }

    public boolean usePSKEncryption() {
        return this.labelFeatures.equals(LabelFeatures.IMPROVED_THROUGHPUT_PROTOCOL);
    }
}

