/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.TransmissionSettings;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.encoding.DC3Encoding;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.encoding.NoEncoding;
import at.mrdevelopment.toolkit.encoding.SimpleByteRunLengthEncoding;

public class LabelFeatures {
    private static final DataEncoding DEFAULT_NO_ENCODING = new NoEncoding();
    private static final int DEFAULT_MAX_PAYLOAD = 32;
    private static final int DEFAULT_MAX_WINDOW_SIZE = 14;
    private static final int DEFAULT_JOIN_INTERVAL = 15;
    private static final boolean DEFAULT_IMPROVED_DATA_PACKET = false;
    private static final DataEncoding DEFAULT_ENCODING = new SimpleByteRunLengthEncoding();
    private static final int IMPROVED_MAX_PAYLOAD = 32;
    private static final int IMPROVED_MAX_WINDOW_SIZE = 14;
    private static final int IMPROVED_JOIN_INTERVAL = 45;
    private static final boolean IMPROVED_IMPROVED_DATA_PACKET = false;
    private static final DataEncoding IMPROVED_ENCODING = new DC3Encoding();
    private final boolean forceWakeupSupported;
    private final boolean commandsOnDataSupported;
    private final boolean securitySupported;
    private final TransmissionSettings transmissionSettings;
    private final DataEncoding compressionAlgorithm;
    private final boolean improvedDataPacket;
    private final int joinIntervalInMinutes;
    public static final LabelFeatures BASIC_PROTOCOL = new LabelFeatures(false, false, DEFAULT_NO_ENCODING, false, 32, 14, false, 15);
    public static final LabelFeatures COMPRESSION_SUPPORTED = new LabelFeatures(false, false, DEFAULT_ENCODING, false, 32, 14, false, 15);
    public static final LabelFeatures EXTENDED_PROTOCOL = new LabelFeatures(false, true, DEFAULT_ENCODING, false, 32, 14, false, 15);
    public static final LabelFeatures SECURE_PROTOCOL = new LabelFeatures(false, true, DEFAULT_ENCODING, true, 32, 14, false, 15);
    public static final LabelFeatures IMPROVED_THROUGHPUT_PROTOCOL = new LabelFeatures(false, true, IMPROVED_ENCODING, true, 32, 14, false, 45);
    public static final Version COMPRESSION_SUPPORTED_VERSION = Version.fromString((String)"2.2.6");
    public static final Version EXTENDED_PROTOCOL_VERSION = Version.fromString((String)"2.3.1");
    public static final Version SECURE_PROTOCOL_VERSION = Version.fromString((String)"3.0.0");
    public static final Version IMPROVED_THROUGHPUT_PROTOCOL_VERSION = Version.fromString((String)"3.1.2");

    public static final LabelFeatures forFirmwareVersion(Version version) {
        if (version.isEqualOrNewer(IMPROVED_THROUGHPUT_PROTOCOL_VERSION)) {
            return IMPROVED_THROUGHPUT_PROTOCOL;
        }
        if (version.isEqualOrNewer(SECURE_PROTOCOL_VERSION)) {
            return SECURE_PROTOCOL;
        }
        if (version.isEqualOrNewer(EXTENDED_PROTOCOL_VERSION)) {
            return EXTENDED_PROTOCOL;
        }
        if (version.isEqualOrNewer(COMPRESSION_SUPPORTED_VERSION)) {
            return COMPRESSION_SUPPORTED;
        }
        return BASIC_PROTOCOL;
    }

    private LabelFeatures(boolean forceWakeupSupported, boolean commandsOnDataSupported, DataEncoding compressionAlgorithm, boolean securitySupported, int maxPayload, int maxWindowSize, boolean improvedDataPacket, int joinIntervalInMinutes) {
        this.forceWakeupSupported = forceWakeupSupported;
        this.commandsOnDataSupported = commandsOnDataSupported;
        this.compressionAlgorithm = compressionAlgorithm;
        this.securitySupported = securitySupported;
        this.transmissionSettings = new TransmissionSettings(maxPayload, maxWindowSize, improvedDataPacket);
        this.improvedDataPacket = improvedDataPacket;
        this.joinIntervalInMinutes = joinIntervalInMinutes;
    }

    public boolean isForceWakeupSupported() {
        return this.forceWakeupSupported;
    }

    public boolean isCommandsOnDataSupported() {
        return this.commandsOnDataSupported;
    }

    public boolean isCompressionSupported() {
        return !(this.compressionAlgorithm instanceof NoEncoding);
    }

    public boolean isSecuritySupported() {
        return this.securitySupported;
    }

    public int getMaxPayload() {
        return this.transmissionSettings.getMaxPayloadSize();
    }

    public int getMaxWindowSize() {
        return this.transmissionSettings.getMaxWindowSize();
    }

    public boolean isImprovedDataPacket() {
        return this.improvedDataPacket;
    }

    public int getJoinIntervalInMinutes() {
        return this.joinIntervalInMinutes;
    }

    public DataEncoding getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public TransmissionSettings getTransmissionSettings() {
        return this.transmissionSettings;
    }

    public String toString() {
        return String.format("forceWakeup=%b; commandsOnData=%b; compression=%b; security=%b; maxPayload=%d; maxWindowSize=%d; improvedDataPacket=%b; joinIntervalInMinutes=%d", this.forceWakeupSupported, this.commandsOnDataSupported, this.compressionAlgorithm.getClass().getSimpleName(), this.securitySupported, this.transmissionSettings.getMaxPayloadSize(), this.transmissionSettings.getMaxWindowSize(), this.improvedDataPacket, this.joinIntervalInMinutes);
    }
}

