/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.JoinStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import org.apache.http.entity.ContentProducer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DiscoveredLabelsContentProducer
implements ContentProducer {
    private static final String START = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><?xml-stylesheet type=\"text/xsl\" href=\"%s\"?><join-requests>";
    private static final String END = "</join-requests>";
    private static final String TAG = "<join-request access-point=\"%d\" address=\"%s\" status=\"%s\" time=\"%s\" time-relative=\"%d\" />";
    private Collection<JoinRequest> entries;
    private JoinStatus filterJoinStatus;
    private int withinSeconds;
    private boolean onlyLabelCount;
    private String stylesheet = "/xsl/accesspoint.xsl";

    public DiscoveredLabelsContentProducer(Collection<JoinRequest> entries, boolean onlyLabelCount, String stylesheet) {
        this.entries = entries;
        this.filterJoinStatus = null;
        this.withinSeconds = 0;
        this.onlyLabelCount = onlyLabelCount;
        this.stylesheet = stylesheet;
    }

    public void writeTo(OutputStream outStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outStream, "UTF-8");
        writer.write(String.format(START, this.stylesheet));
        if (this.onlyLabelCount) {
            writer.write("<count>");
            writer.write(Integer.toString(this.entries.size()));
            writer.write("</count>");
        } else {
            for (JoinRequest entry : this.entries) {
                DateTime filterStartTime;
                JoinStatus joinStatus = entry.getJoinStatus();
                DateTime joinTime = entry.getTime();
                DateTime now = DateTime.now();
                DateTime dateTime = filterStartTime = this.withinSeconds != 0 ? now.minusSeconds(this.withinSeconds) : null;
                if (this.filterJoinStatus != null && this.filterJoinStatus != joinStatus || filterStartTime != null && !joinTime.isAfter((ReadableInstant)filterStartTime)) continue;
                writer.write(String.format(TAG, entry.getAccessPointId(), entry.getLabelAddress().toString(), entry.getJoinStatus().name(), entry.getTime().toLocalDateTime().toString(), Math.max(now.getMillis() - entry.getTime().getMillis(), 0L)));
            }
        }
        writer.write(END);
        writer.close();
    }
}

