/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.SlotIdReader;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import java.io.IOException;

public class DefaultSlotIdReader
implements SlotIdReader {
    private static final int COMPATIBILITY_FLAG = 1;

    @Override
    public int readRawSlotId(FrameInputStream inputStream) throws IOException {
        return inputStream.readWord();
    }

    @Override
    public SlotId getSlotId(int rawSlotId) {
        return new SlotId(rawSlotId);
    }

    @Override
    public int getSlotInfoWord(int rawSlotId, SyncPacket syncPacket) {
        return syncPacket.getSyncProfile().getProfileId() << 13 | 0x800 | syncPacket.getSlotId().getId() & 0x3FF;
    }

    @Override
    public int getSlotInfoWordForThinAp(int slotId, SyncPacket syncPacket) {
        return syncPacket.getSyncProfile().getProfileId() << 13 | 0x800 | slotId & 0x3FF;
    }

    @Override
    public int getSlotInfoWordForEmptySync(int syncProfileId) {
        return syncProfileId << 13 | 0x800;
    }

    @Override
    public int getSlotIdForThinAp(int slotId) {
        return slotId & 0x3FF;
    }
}

