/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingAssignment;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.wireless.SyncProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class DefaultInternalRoamingTable
implements InternalRoamingTable {
    public static AtomicLong PUT_COUNTER_LABEL_TYPES = new AtomicLong(0L);
    public static AtomicLong PUT_COUNTER_PINS = new AtomicLong(0L);
    private final List<Set<Address>> assignedLabelsBySlot = new ArrayList<Set<Address>>(1024);
    private final Set<Address> assignedLabels;
    private final Set<Address> registeredLabels;
    private final Set<WirelessChannel> usedChannels;
    private final Map<Address, LabelType> labelTypes;
    private final Map<Address, Pin> pins;
    private final int assignedLabelsCount;
    private final DateTime updateTime;
    private final boolean isValid;
    private final int validTimeInMinutes;
    private final int pingIntervalInMinutes;
    private final boolean acceptAllLabels;
    private final String remoteHostName;
    private final String remoteHostAddress;
    private final Key key;
    private final int protocolId;
    private final String usedChannelsString;
    private final SyncProfile syncProfile;
    private final boolean encryptionRequired;

    public DefaultInternalRoamingTable() {
        this.initAssignedLabelsBySlot();
        this.assignedLabels = Collections.emptySet();
        this.registeredLabels = Collections.emptySet();
        this.usedChannels = Collections.emptySet();
        this.labelTypes = Collections.emptyMap();
        this.pins = Collections.emptyMap();
        this.assignedLabelsCount = 0;
        this.updateTime = DateTime.now();
        this.isValid = false;
        this.validTimeInMinutes = 10;
        this.pingIntervalInMinutes = 0;
        this.acceptAllLabels = false;
        this.remoteHostName = "";
        this.remoteHostAddress = "";
        this.usedChannelsString = "[]";
        this.key = Key.emptyKey();
        this.protocolId = 0;
        this.syncProfile = SyncProfile.RETAIL_DEFAULT;
        this.encryptionRequired = false;
    }

    public DefaultInternalRoamingTable(RoamingTable roamingTable, int accessPointId, String remoteHostName, String remoteHostAddress) {
        this.initAssignedLabelsBySlot();
        this.assignedLabels = new HashSet<Address>();
        this.registeredLabels = new HashSet<Address>(roamingTable.getRoamingAssignments().size(), 1.0f);
        this.usedChannels = new HashSet<WirelessChannel>(roamingTable.getChannelTable().size(), 1.0f);
        this.labelTypes = new HashMap<Address, LabelType>(roamingTable.getRoamingAssignments().size(), 1.0f);
        this.pins = new HashMap<Address, Pin>();
        this.updateTime = DateTime.now();
        this.isValid = true;
        this.validTimeInMinutes = roamingTable.getValidTimeInMinutes();
        this.pingIntervalInMinutes = roamingTable.getPingIntervalInMinutes();
        this.acceptAllLabels = roamingTable.isAcceptAllLabels();
        this.remoteHostName = remoteHostName;
        this.remoteHostAddress = remoteHostAddress;
        this.key = roamingTable.getKey() == null ? Key.emptyKey() : roamingTable.getKey();
        this.protocolId = roamingTable.getProtocolId();
        this.syncProfile = roamingTable.getSyncProfile();
        this.encryptionRequired = roamingTable.isEncryptionRequired();
        for (ChannelTableEntry channelEntry : roamingTable.getChannelTable()) {
            this.usedChannels.add(channelEntry.getWirelessChannel());
        }
        int assignedLabelsCount = 0;
        for (RoamingAssignment roamingAssignment : roamingTable.getRoamingAssignments()) {
            Address labelAddress = roamingAssignment.getAddress();
            int slotId = labelAddress.getSlot();
            if (roamingAssignment.isAssigned()) {
                if (accessPointId == roamingAssignment.getAccessPointId()) {
                    this.assignedLabelsBySlot.get(slotId).add(labelAddress);
                    this.assignedLabels.add(labelAddress);
                    ++assignedLabelsCount;
                }
                if (roamingAssignment.hasPin()) {
                    this.pins.put(labelAddress, roamingAssignment.getPin());
                }
            }
            PUT_COUNTER_LABEL_TYPES.incrementAndGet();
            this.labelTypes.put(labelAddress, roamingAssignment.getLabelType());
            this.registeredLabels.add(labelAddress);
        }
        this.assignedLabelsCount = assignedLabelsCount;
        this.usedChannelsString = String.format("[%s]", StringUtils.join(this.usedChannels, (String)", "));
    }

    private void initAssignedLabelsBySlot() {
        for (int slotId = 0; slotId < 1024; ++slotId) {
            this.assignedLabelsBySlot.add(slotId, new HashSet());
        }
    }

    public Collection<Address> getAssignedLabelsForSlot(int slotId) {
        return Collections.unmodifiableSet(this.assignedLabelsBySlot.get(slotId));
    }

    public Set<Address> getAssignedLabels() {
        return Collections.unmodifiableSet(this.assignedLabels);
    }

    public int getAssignedLabelsCount() {
        return this.assignedLabelsCount;
    }

    public int getRegisteredLabelsCount() {
        return this.registeredLabels.size();
    }

    public Set<Address> getRegisteredLabels() {
        return Collections.unmodifiableSet(this.registeredLabels);
    }

    public Set<WirelessChannel> getUsedChannels() {
        return Collections.unmodifiableSet(this.usedChannels);
    }

    public int getValidTimeInMinutes() {
        return this.validTimeInMinutes;
    }

    public int getPingIntervalInMinutes() {
        return this.pingIntervalInMinutes;
    }

    public boolean isAcceptAllLabels() {
        return this.acceptAllLabels;
    }

    public DateTime getUpdateTime() {
        return this.updateTime;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    public String getRemoteHostAddress() {
        return this.remoteHostAddress;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean hasKey() {
        return !this.key.isEmptyKey();
    }

    public Pin getPin(Address labelAddress) {
        return this.pins.get(labelAddress);
    }

    public boolean hasPin(Address labelAddress) {
        return this.pins.containsKey(labelAddress);
    }

    public boolean isTimedOut(DateTime now) {
        return Minutes.minutesBetween((ReadableInstant)this.updateTime, (ReadableInstant)now).getMinutes() >= this.validTimeInMinutes;
    }

    public boolean isLabelRegistered(Address labelAddress) {
        return this.acceptAllLabels || this.registeredLabels.contains(labelAddress);
    }

    public String getUsedChannelsString() {
        return this.usedChannelsString;
    }

    public int getProtocoId() {
        return this.protocolId;
    }

    public LabelType getLabelType(Address address) {
        return this.labelTypes.get(address);
    }

    public SyncProfile getSyncProfile() {
        return this.syncProfile;
    }

    public boolean isEncryptionRequired() {
        return this.encryptionRequired;
    }
}

