/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class CommunicationDaemonLogger
extends Thread
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(CommunicationDaemonLogger.class);
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private boolean shutdownRequested = false;
    private ServerSocket serverSocket;
    private Socket currentConnectionSocket = null;
    private ObjectInputStream inputStream = null;

    public CommunicationDaemonLogger(int port) throws InitializationException {
        try {
            this.serverSocket = new ServerSocket(port, 0, InetAddress.getByName("127.0.0.1"));
            this.serverSocket.setSoTimeout(60000);
        }
        catch (IOException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    @Override
    public void run() {
        while (!this.shutdownRequested) {
            try {
                if (this.currentConnectionSocket == null) {
                    this.currentConnectionSocket = this.accept();
                }
                if (this.inputStream == null) {
                    this.inputStream = new ObjectInputStream(new BufferedInputStream(this.currentConnectionSocket.getInputStream()));
                }
                this.handleLogMessages();
            }
            catch (SocketTimeoutException ignore) {
            }
            catch (EOFException exc) {
                logger.debug("Got EOF reading from communication-daemon logging socket");
                this.cleanup();
            }
            catch (Exception exc) {
                logger.warn("Error during communication daemon logging: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                this.cleanup();
            }
        }
        this.cleanup();
    }

    private void handleLogMessages() throws Exception {
        while (!this.shutdownRequested) {
            if (this.inputStream != null) {
                LoggingEvent event = (LoggingEvent)this.inputStream.readUnshared();
                Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
                while (allAppenders.hasMoreElements()) {
                    Appender appender = (Appender)allAppenders.nextElement();
                    appender.doAppend(event);
                }
                continue;
            }
            return;
        }
    }

    private Socket accept() throws IOException {
        Socket socket = this.serverSocket.accept();
        socket.setSoTimeout(60000);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException exc) {
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                logger.warn("Error closing inputstream");
            }
            finally {
                this.inputStream = null;
            }
        }
        if (this.currentConnectionSocket != null) {
            try {
                this.currentConnectionSocket.close();
            }
            catch (IOException exc) {
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                logger.warn("Error closing socket");
            }
            finally {
                this.currentConnectionSocket = null;
            }
        }
    }

    public void shutdown() {
        this.shutdownRequested = true;
        this.interrupt();
    }
}

