/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointWakeupStatisticsListenerIF;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.JoinStatus;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.xml.JoinRequestXMLSerializer;
import at.mrdevelopment.esl.xml.LabelEventXMLSerializer;
import at.mrdevelopment.esl.xml.WakeupStatisticXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AccessPointWakeupStatisticsListener
implements AccessPointWakeupStatisticsListenerIF {
    private static final int LABEL_TIMEOUT_OFFSET_IN_MINUTES = 5;
    private volatile Set<Address> assignedLabels = Collections.emptySet();
    private volatile int pingIntervalInMinutes = 0;
    private volatile boolean isAcceptAllLabels = false;
    protected final WakeupStatisticXMLSerializer xmlWakeupStatistics;
    protected final JoinRequestXMLSerializer xmlJoinRequests;
    protected final LabelEventXMLSerializer xmlLabelEvents;
    private Lock wakeupLock = new ReentrantLock();
    private Lock joinLock = new ReentrantLock();
    private Lock eventLock = new ReentrantLock();
    private final TLongObjectHashMap<WakeupStatistic> wakeupStatistics = new TLongObjectHashMap();
    private final TLongObjectHashMap<JoinRequest> joinRequests = new TLongObjectHashMap();
    private TLongObjectHashMap<LabelEvent> eventEntries = new TLongObjectHashMap();
    private final Document labelEventsDocument;

    protected AccessPointWakeupStatisticsListener() throws InitializationException {
        this.xmlWakeupStatistics = new WakeupStatisticXMLSerializer();
        this.xmlJoinRequests = new JoinRequestXMLSerializer();
        this.xmlLabelEvents = new LabelEventXMLSerializer();
        this.labelEventsDocument = this.xmlLabelEvents.newDocument();
    }

    @Override
    public void roamingTableChanged(InternalRoamingTable roamingTable) {
        this.pingIntervalInMinutes = roamingTable.getPingIntervalInMinutes();
        this.assignedLabels = roamingTable.getAssignedLabels();
        this.isAcceptAllLabels = roamingTable.isAcceptAllLabels();
    }

    @Override
    public boolean isAcceptAllLabels() {
        return this.isAcceptAllLabels;
    }

    private int getLabelTimeoutInSeconds() {
        return (this.pingIntervalInMinutes + 5) * 60;
    }

    private Set<Address> getAssignedLabels() {
        return this.assignedLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedLabelEvent(LabelEvent labelEvent) {
        this.eventLock.lock();
        try {
            this.eventEntries.put(labelEvent.getLabelAddress().getHardwareAddress(), (Object)labelEvent);
        }
        finally {
            this.eventLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getLabelEventsDocument() {
        Document document = this.xmlLabelEvents.newDocument();
        Element root = document.createElement("events");
        document.appendChild(root);
        DateTime now = DateTime.now();
        this.eventLock.lock();
        try {
            TLongObjectIterator iterator = this.eventEntries.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                LabelEvent event = (LabelEvent)iterator.value();
                Element importedNode = (Element)document.importNode(this.xmlLabelEvents.labelEventToXML(this.labelEventsDocument, event), true);
                this.xmlLabelEvents.updateTime(importedNode, event.getReceivedTime(), now);
                root.appendChild(importedNode);
            }
        }
        finally {
            this.eventLock.unlock();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeoutLabelEvents(DateTime now, int validTimeInMinutes) {
        this.eventLock.lock();
        try {
            TLongObjectIterator iterator = this.eventEntries.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                LabelEvent event = (LabelEvent)iterator.value();
                if (Minutes.minutesBetween((ReadableInstant)event.getReceivedTime(), (ReadableInstant)now).getMinutes() < validTimeInMinutes) continue;
                iterator.remove();
            }
        }
        finally {
            this.eventLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LabelEvent> getLabelEvents() {
        List<Object> events;
        this.eventLock.lock();
        try {
            events = Arrays.asList(this.eventEntries.values((Object[])new LabelEvent[0]));
        }
        finally {
            this.eventLock.unlock();
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedEventConfirm(Address labelAddress) {
        this.eventLock.lock();
        try {
            LabelEvent event = (LabelEvent)this.eventEntries.get(labelAddress.getHardwareAddress());
            if (event != null) {
                event.confirmEvent();
            }
        }
        finally {
            this.eventLock.unlock();
        }
    }

    public void receivedWakeup(WakeupStatistic wakeupStatistic) {
        if (this.isAcceptAllLabels()) {
            return;
        }
        this.put(wakeupStatistic.getLabelAddress(), wakeupStatistic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WakeupStatistic getWakeupEntry(Address labelAddress) {
        WakeupStatistic entry = null;
        try {
            this.wakeupLock.lock();
            entry = (WakeupStatistic)this.wakeupStatistics.get(labelAddress.getHardwareAddress());
        }
        finally {
            this.wakeupLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(Address labelAddress, WakeupStatistic entry) {
        try {
            this.wakeupLock.lock();
            this.wakeupStatistics.put(labelAddress.getHardwareAddress(), (Object)entry);
        }
        finally {
            this.wakeupLock.unlock();
        }
    }

    protected LinkedList<WakeupStatistic> getWakeupStatistics(Collection<Address> labels, int labelTimeoutInSeconds, ConnectionStatus filterConnectionStatus) {
        DateTime now = DateTime.now();
        LinkedList<WakeupStatistic> filteredStatistics = new LinkedList<WakeupStatistic>();
        for (Address labelAddress : labels) {
            WakeupStatistic entry = this.getWakeupEntry(labelAddress);
            if (entry == null) continue;
            DateTime lastPingReplyTime = entry.getLastPingReplyTime();
            ConnectionStatus connectionStatus = ConnectionStatus.getStatus((DateTime)now, (DateTime)lastPingReplyTime, (int)labelTimeoutInSeconds);
            if (filterConnectionStatus != null && filterConnectionStatus != connectionStatus) continue;
            filteredStatistics.add(entry);
        }
        return filteredStatistics;
    }

    protected Document getWakeupStatisticsDocument(Collection<Address> labels, int labelTimeoutInSeconds, ConnectionStatus filterConnectionStatus, boolean removeNewFields) {
        Document document = this.xmlWakeupStatistics.newDocument();
        Element root = document.createElement("wakeup-statistics");
        document.appendChild(root);
        if (!this.isAcceptAllLabels()) {
            DateTime now = DateTime.now();
            for (WakeupStatistic entry : this.getWakeupStatistics(labels, labelTimeoutInSeconds, filterConnectionStatus)) {
                Element newNode = this.wakeupStatisticToXML(document, entry);
                ConnectionStatus connectionStatus = ConnectionStatus.getStatus((DateTime)now, (DateTime)entry.getLastPingReplyTime(), (int)labelTimeoutInSeconds);
                this.xmlWakeupStatistics.updateTime(newNode, entry.getLastPingReplyTime(), now);
                this.xmlWakeupStatistics.updateConnectionStatus(newNode, connectionStatus);
                if (removeNewFields) {
                    this.xmlWakeupStatistics.removeNewFields(newNode);
                }
                root.appendChild(newNode);
            }
        }
        return document;
    }

    @Override
    public Document getAssignedLabelsDocument() {
        return this.getLabelsWithConnectionStatusDocument(null, true);
    }

    @Override
    public Document getLabelsWithConnectionStatusDocument(ConnectionStatus connectionStatus) {
        return this.getLabelsWithConnectionStatusDocument(connectionStatus, false);
    }

    @Override
    public Document getLabelsWithConnectionStatusDocument(ConnectionStatus filterConnectionStatus, boolean removeNewFields) {
        return this.getWakeupStatisticsDocument(this.getAssignedLabels(), this.getLabelTimeoutInSeconds(), filterConnectionStatus, removeNewFields);
    }

    public LinkedList<WakeupStatistic> getLabelsLastSeenWithinSeconds(int lastSeenWithinSeconds) {
        if (lastSeenWithinSeconds > 0) {
            return this.getWakeupStatistics(this.getAssignedLabels(), lastSeenWithinSeconds, ConnectionStatus.ONLINE);
        }
        return this.getWakeupStatistics(this.getAssignedLabels(), this.getLabelTimeoutInSeconds(), null);
    }

    @Override
    public Document getLabelsLastSeenWithinSecondsDocument(int lastSeenWithinSeconds) {
        if (lastSeenWithinSeconds > 0) {
            return this.getWakeupStatisticsDocument(this.getAssignedLabels(), lastSeenWithinSeconds, ConnectionStatus.ONLINE, false);
        }
        return this.getWakeupStatisticsDocument(this.getAssignedLabels(), this.getLabelTimeoutInSeconds(), null, false);
    }

    private Element wakeupStatisticToXML(Document document, WakeupStatistic ws) {
        Element element = document.createElement("wakeup-statistic");
        element.setAttribute("address", ws.getLabelAddress().toString());
        element.setAttribute("access-point", Integer.toString(ws.getAccessPointId()));
        element.setAttribute("count", Long.toString(ws.getWakeupCount()));
        if (ws.getWakeupCount() > 0L) {
            element.setAttribute("time", this.xmlJoinRequests.formatTime(ws.getLastPingReplyTime()));
            element.setAttribute("firmware", ws.getFirmwareVersion().toString());
            element.setAttribute("sync-quality", Integer.toString(ws.getSyncQuality().getSyncQualityValue()));
            element.setAttribute("power-status", ws.getPowerStatus().toString());
            element.setAttribute("key-unset", Boolean.toString(ws.isKeyUnset()));
            element.setAttribute("keys-not-programmed", Boolean.toString(ws.areKeysNotProgrammed()));
            element.setAttribute("page", ws.getCurrentPage().getPageString());
            element.setAttribute("error-code", Integer.toString(ws.getLabelErrors().getErrorCode()));
            element.setAttribute("rssi", Integer.toString(ws.getLastRssi()));
            element.setAttribute("lqi", Integer.toString(ws.getLastLqi()));
            element.setAttribute("sync", ws.getSyncQuality().getSyncQualityLevel().toString());
        }
        return element;
    }

    public void receivedJoinRequest(JoinRequest joinRequest) {
        Address labelAddress = joinRequest.getLabelAddress();
        this.put(labelAddress, joinRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JoinRequest getJoinRequest(Address labelAddress) {
        JoinRequest join = null;
        try {
            this.joinLock.lock();
            join = (JoinRequest)this.joinRequests.get(labelAddress.getHardwareAddress());
        }
        finally {
            this.joinLock.unlock();
        }
        return join;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(Address labelAddress, JoinRequest joinRequest) {
        try {
            this.joinLock.lock();
            this.joinRequests.put(labelAddress.getHardwareAddress(), (Object)joinRequest);
        }
        finally {
            this.joinLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JoinRequest> getAllJoinRequests() {
        ArrayList<JoinRequest> arrayList;
        try {
            this.joinLock.lock();
            arrayList = new ArrayList<JoinRequest>(this.joinRequests.valueCollection());
        }
        finally {
            this.joinLock.unlock();
        }
        return arrayList;
    }

    public LinkedList<JoinRequest> getJoinRequestsWithJoinStatus(JoinStatus filterJoinStatus, int withinSeconds) {
        LinkedList<JoinRequest> requests = new LinkedList<JoinRequest>();
        if (!this.isAcceptAllLabels()) {
            DateTime now = DateTime.now();
            DateTime filterStartTime = withinSeconds != 0 ? now.minusSeconds(withinSeconds) : null;
            Collection<JoinRequest> allJoins = this.getAllJoinRequests();
            for (JoinRequest entry : allJoins) {
                JoinStatus joinStatus = entry.getJoinStatus();
                DateTime joinTime = entry.getTime();
                if (filterJoinStatus != null && filterJoinStatus != joinStatus || filterStartTime != null && !joinTime.isAfter((ReadableInstant)filterStartTime)) continue;
                requests.add(entry);
            }
        }
        return requests;
    }

    @Override
    public Document getAllJoinRequestsDocument() {
        return this.getJoinRequestsWithJoinStatusDocument(null, 0);
    }

    @Override
    public Document getJoinRequestsWithJoinStatusDocument(JoinStatus filterJoinStatus, int withinSeconds) {
        Document document = this.xmlJoinRequests.newDocument();
        Element root = document.createElement("join-requests");
        document.appendChild(root);
        DateTime now = DateTime.now();
        for (JoinRequest jr : this.getJoinRequestsWithJoinStatus(filterJoinStatus, withinSeconds)) {
            Element element = this.joinRequestToXML(document, jr);
            this.xmlJoinRequests.updateTime(element, jr.getTime(), now);
            root.appendChild(element);
        }
        return document;
    }

    private Element joinRequestToXML(Document document, JoinRequest joinRequest) {
        Element element = document.createElement("join-request");
        element.setAttribute("address", joinRequest.getLabelAddress().toString());
        element.setAttribute("access-point", Integer.toString(joinRequest.getAccessPointId()));
        element.setAttribute("time", this.xmlJoinRequests.formatTime(joinRequest.getTime()));
        element.setAttribute("status", joinRequest.getJoinStatus().toString());
        return element;
    }

    @Override
    public Document getLabelDocument(Address labelAddress) {
        Document document = this.xmlWakeupStatistics.newDocument();
        Element root = document.createElement("label-details");
        document.appendChild(root);
        if (!this.isAcceptAllLabels()) {
            JoinRequest joinRequest;
            DateTime now = DateTime.now();
            WakeupStatistic wakeupEntry = this.getWakeupEntry(labelAddress);
            if (wakeupEntry != null) {
                DateTime lastPingReplyTime = wakeupEntry.getLastPingReplyTime();
                ConnectionStatus connectionStatus = ConnectionStatus.getStatus((DateTime)now, (DateTime)lastPingReplyTime, (int)this.getLabelTimeoutInSeconds());
                Element newNode = this.wakeupStatisticToXML(document, wakeupEntry);
                this.xmlWakeupStatistics.updateTime(newNode, lastPingReplyTime, now);
                this.xmlWakeupStatistics.updateConnectionStatus(newNode, connectionStatus);
                root.appendChild(newNode);
            }
            if ((joinRequest = this.getJoinRequest(labelAddress)) != null) {
                DateTime joinTime = joinRequest.getTime();
                Element element = this.joinRequestToXML(document, joinRequest);
                this.xmlJoinRequests.updateTime(element, joinTime, now);
                root.appendChild(element);
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOldEntries(long timeDifferenceInMillis) {
        TLongObjectIterator iterator;
        long now = DateTime.now().getMillis();
        try {
            this.joinLock.lock();
            iterator = this.joinRequests.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                JoinRequest join = (JoinRequest)iterator.value();
                if (now - join.getTime().getMillis() < timeDifferenceInMillis) continue;
                iterator.remove();
            }
        }
        finally {
            this.joinLock.unlock();
        }
        try {
            this.wakeupLock.lock();
            iterator = this.wakeupStatistics.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                WakeupStatistic entry = (WakeupStatistic)iterator.value();
                if (now - entry.getLastPingReplyTime().getMillis() < timeDifferenceInMillis) continue;
                iterator.remove();
            }
        }
        finally {
            this.wakeupLock.unlock();
        }
    }
}

