/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointDataListener;
import at.mrdevelopment.esl.core.UpdateTaskListener;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.UpdateTaskSAXXMLSerializer;
import at.mrdevelopment.esl.updatetask.UpdateTaskXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AccessPointUpdateTasksListener
implements UpdateTaskListener {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointDataListener.class);
    private final UpdateTaskXMLSerializer xmlUpdateTasks = new UpdateTaskXMLSerializer();
    private final UpdateTaskSAXXMLSerializer saxXmlUpdateTasks = new UpdateTaskSAXXMLSerializer();
    private final Document updateTasksDocument = this.xmlUpdateTasks.newDocument();
    private final ConcurrentHashMap<UUID, Entry> updateTasks = new ConcurrentHashMap(16, 0.75f, 4);

    public void updateTaskAdded(ExternalUpdateTask updateTask) {
        UUID taskId = updateTask.getTaskId();
        Entry entry = this.toEntry(updateTask);
        this.updateTasks.put(taskId, entry);
    }

    public void updateTaskChanged(ExternalUpdateTask updateTask) {
        UUID taskId = updateTask.getTaskId();
        Entry entry = this.toEntry(updateTask);
        this.updateTasks.replace(taskId, entry);
    }

    public void updateTaskRemoved(ExternalUpdateTask updateTask) {
        UUID taskId = updateTask.getTaskId();
        this.updateTasks.remove(taskId);
    }

    private Entry toEntry(ExternalUpdateTask updateTask) {
        try {
            Element element = this.xmlUpdateTasks.updateTaskToXML(this.updateTasksDocument, updateTask, false);
            return new Entry(updateTask, element, updateTask.isFinished());
        }
        catch (SerializeException exc) {
            throw new RuntimeException(exc);
        }
    }

    public List<ExternalUpdateTask> getUpdateTasks(Collection<UUID> taskIds) {
        ArrayList<ExternalUpdateTask> selectedUpdateTasks = new ArrayList<ExternalUpdateTask>(taskIds.size());
        for (UUID taskId : taskIds) {
            Entry entry = this.updateTasks.get(taskId);
            if (entry == null) continue;
            selectedUpdateTasks.add(entry.updateTask);
        }
        return selectedUpdateTasks;
    }

    public List<ExternalUpdateTask> getAllUpdateTasks() {
        ArrayList<ExternalUpdateTask> allUpdateTasks = new ArrayList<ExternalUpdateTask>(this.updateTasks.size());
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
        for (Entry entry : this.updateTasks.values()) {
            allUpdateTasks.add(entry.updateTask);
        }
        timeLogger.logTimeInfo("Get all update tasks");
        return allUpdateTasks;
    }

    public List<ExternalUpdateTask> getTimedOutUpdateTasks(DateTime now, int validTimeInMinutes) {
        ArrayList<ExternalUpdateTask> timedOutUpdateTasks = new ArrayList<ExternalUpdateTask>(this.updateTasks.size());
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
        for (Entry entry : this.updateTasks.values()) {
            if (!entry.finished || Minutes.minutesBetween((ReadableInstant)entry.updateTask.getUpdatedAtTime(), (ReadableInstant)now).getMinutes() < validTimeInMinutes) continue;
            timedOutUpdateTasks.add(entry.updateTask);
        }
        timeLogger.logTimeInfo("Get finished update tasks");
        return timedOutUpdateTasks;
    }

    private Collection<Element> getAllUpdateTaskElements() {
        ArrayList<Element> elements = new ArrayList<Element>(this.updateTasks.size());
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
        for (Entry entry : this.updateTasks.values()) {
            elements.add(entry.element);
        }
        timeLogger.logTimeInfo("Get all update task elements");
        return elements;
    }

    private Collection<Element> getFinishedUpdateTaskElements() {
        ArrayList<Element> elements = new ArrayList<Element>(this.updateTasks.size());
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
        for (Entry entry : this.updateTasks.values()) {
            if (!entry.finished) continue;
            elements.add(entry.element);
        }
        timeLogger.logTimeInfo("Get finished update task elements");
        return elements;
    }

    private Document getUpdateTasksDocument(Collection<Element> elements) {
        Document document = this.xmlUpdateTasks.newDocument();
        Element root = document.createElement("update-tasks");
        document.appendChild(root);
        for (Element element : elements) {
            Node importedNode = document.importNode(element, true);
            root.appendChild(importedNode);
        }
        return document;
    }

    public Document getAllUpdateTasksDocument() {
        return this.getUpdateTasksDocument(this.getAllUpdateTaskElements());
    }

    public Document getFinishedUpdateTasksDocument() {
        return this.getUpdateTasksDocument(this.getFinishedUpdateTaskElements());
    }

    public Document getUpdateTaskDocument(UUID taskId) {
        Entry entry = this.updateTasks.get(taskId);
        if (entry == null) {
            return null;
        }
        Document document = this.xmlUpdateTasks.newDocument();
        Node importedNode = document.importNode(entry.element, true);
        document.appendChild(importedNode);
        return document;
    }

    public List<ExternalUpdateTask> parseUpdateTasks(InputStream inputStream) throws SerializeException {
        return this.saxXmlUpdateTasks.parseXML(inputStream);
    }

    private static class Entry {
        final ExternalUpdateTask updateTask;
        final Element element;
        final boolean finished;

        Entry(ExternalUpdateTask updateTask, Element element, boolean finished) {
            this.updateTask = updateTask;
            this.element = element;
            this.finished = finished;
        }
    }
}

