/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointBaseServiceStatusUpdater;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.ThinAPVisibilityContext;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.toolkit.InitializationException;
import org.joda.time.DateTime;

public class AccessPointThinServiceStatusUpdater
extends AccessPointBaseServiceStatusUpdater {
    public AccessPointThinServiceStatusUpdater(AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, ConnectionStatus initialStatus) throws InitializationException {
        super(configurationManager, systemAttributes, runtimeConfiguration, ThinAPVisibilityContext.createFullContext(), initialStatus);
        this.updateServiceStatusDocument(DateTime.now());
    }

    @Override
    protected ServiceStatus createServiceStatus(DateTime now) {
        ServiceStatus serviceStatus = new ServiceStatus("Access Point");
        EnvironmentProperties envProperties = this.envPropertiesHolder.get();
        WirelessChannel channel = this.configurationManager.getWirelessConfiguration().getChannel();
        super.addCommonProperties(serviceStatus, channel, envProperties, now);
        super.addThinAP20SpecificProperties(serviceStatus);
        serviceStatus.setProperty("server-hostname", "");
        serviceStatus.setProperty("server-address", this.channelStatusProvider != null ? this.channelStatusProvider.getSlotChannelRemoteEndpoint() : "");
        super.addJVMProperties(serviceStatus, envProperties, now);
        serviceStatus.setProperty("thinap-mode", true);
        serviceStatus.setProperty("outbound-mode", this.configurationManager.getThinAPConfiguration().isOutboundModeEnabled().booleanValue());
        if (this.configurationManager.getThinAPConfiguration().isOutboundModeEnabled().booleanValue()) {
            serviceStatus.setProperty("apc-address", this.configurationManager.getThinAPConfiguration().getApcAddress());
            serviceStatus.setProperty("apc-port", (long)this.configurationManager.getThinAPConfiguration().getApcPort());
        }
        serviceStatus.setProperty("protocol-tls", this.configurationManager.getThinAPConfiguration().isTLSEnabled());
        super.addProblems(serviceStatus, now);
        return serviceStatus;
    }
}

