/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointBaseServiceStatusUpdater;
import at.mrdevelopment.esl.accesspoint.AccessPointEventListener;
import at.mrdevelopment.esl.accesspoint.AccessPointProblem;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.DefaultInternalRoamingTable;
import at.mrdevelopment.esl.accesspoint.RegisteredLabelsContentProducer;
import at.mrdevelopment.esl.accesspoint.RoamingTableListener;
import at.mrdevelopment.esl.accesspoint.ThinAPVisibilityContext;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.UpdateTaskListener;
import at.mrdevelopment.esl.core.UpdateTaskQueueListener;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.processing.ConnectionStatusListener;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.xml.sax.RoamingTableSAXXMLSerializer;
import at.mrdevelopment.toolkit.ConversionUtils;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.lancom.LancomInfo;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.problem.MessageProblem;
import at.mrdevelopment.toolkit.problem.Problem;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.entity.ContentProducer;
import org.joda.time.DateTime;

public class AccessPointThickServiceStatusUpdater
extends AccessPointBaseServiceStatusUpdater
implements UpdateTaskListener,
UpdateTaskQueueListener,
RoamingTableListener,
AccessPointEventListener,
ConnectionStatusListener {
    private static final ESLLogger logger = ESLLogger.getLogger(AccessPointThickServiceStatusUpdater.class);
    private int updateTaskCount = 0;
    private int waitingUpdateTasksCount = 0;
    private int updateTaskTotalSize = 0;
    private int uartErrors = 0;
    private volatile InternalRoamingTable roamingTable = new DefaultInternalRoamingTable();
    private AtomicReference<Set<Address>> newRegisteredLabels = new AtomicReference();
    private final RoamingTableSAXXMLSerializer xmlRoamingTable;
    private final RegisteredLabelsContentProducer registeredLabelsContentProducer;
    private final Mode mode;
    private LancomInfo lancomInfo;
    private final Object lock = new Object();
    private final boolean isTcpLancom;

    public AccessPointThickServiceStatusUpdater(AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, ConnectionStatus initialStatus, Mode mode, ThinAPVisibilityContext thinAPContext) throws InitializationException {
        super(configurationManager, systemAttributes, runtimeConfiguration, thinAPContext, initialStatus);
        this.mode = mode;
        this.isTcpLancom = AccessPointTypeMapping.getType((int)systemAttributes.getId()) == AccessPointType.LANCOM;
        this.connectionStatus = initialStatus;
        this.xmlRoamingTable = new RoamingTableSAXXMLSerializer();
        this.registeredLabelsContentProducer = new RegisteredLabelsContentProducer();
        this.updateServiceStatusDocument(DateTime.now());
        this.setNewRegisteredLabels(this.roamingTable.getRegisteredLabels());
    }

    public AccessPointThickServiceStatusUpdater(AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, ConnectionStatus initialStatus) throws InitializationException {
        super(configurationManager, systemAttributes, runtimeConfiguration, ThinAPVisibilityContext.createFullContext(), initialStatus);
        this.mode = Mode.OTHER;
        this.isTcpLancom = AccessPointTypeMapping.getType((int)systemAttributes.getId()) == AccessPointType.LANCOM;
        this.connectionStatus = initialStatus;
        this.xmlRoamingTable = new RoamingTableSAXXMLSerializer();
        this.registeredLabelsContentProducer = new RegisteredLabelsContentProducer();
        this.updateServiceStatusDocument(DateTime.now());
        this.setNewRegisteredLabels(this.roamingTable.getRegisteredLabels());
    }

    public synchronized void updateTaskAdded(ExternalUpdateTask updateTask) {
        if (updateTask.isWaiting()) {
            ++this.waitingUpdateTasksCount;
        } else {
            logger.warn("Added task %s with non-waiting status %s", new Object[]{updateTask.getTaskId(), updateTask.getStatus()});
        }
    }

    public synchronized void updateTaskChanged(ExternalUpdateTask updateTask) {
        if (updateTask.isFinished()) {
            --this.waitingUpdateTasksCount;
        }
    }

    public synchronized void updateTaskRemoved(ExternalUpdateTask updateTask) {
        --this.updateTaskCount;
        this.updateTaskTotalSize -= updateTask.getSize();
    }

    @Override
    public void roamingTableChanged(InternalRoamingTable roamingTable) {
        this.roamingTable = roamingTable;
        this.setNewRegisteredLabels(roamingTable.getRegisteredLabels());
        logger.info("Updated roaming table received from %s. Number of registered labels %d and valid for %d minutes.", new Object[]{roamingTable.getRemoteHostAddress(), roamingTable.getRegisteredLabelsCount(), roamingTable.getValidTimeInMinutes()});
    }

    @Override
    public void tasksAdded() {
    }

    @Override
    public synchronized void uartError() {
        ++this.uartErrors;
    }

    @Override
    public void problemDetected(AccessPointProblem problem) {
        this.problems.put(problem, DateTime.now());
    }

    private void setNewRegisteredLabels(Set<Address> registeredLabels) {
        this.newRegisteredLabels.set(registeredLabels);
    }

    public void updateRegisteredLabelsDocument() {
        Set newRegistered = this.newRegisteredLabels.getAndSet(null);
        if (newRegistered != null) {
            ArrayList<Address> temp = new ArrayList<Address>(newRegistered);
            Collections.sort(temp);
            this.registeredLabelsContentProducer.updateRegisteredLabels(temp);
        }
    }

    public InternalRoamingTable parseRoamingTable(InputStream inputStream, String remoteHostName, String remoteHostAddress) throws SerializeException {
        RoamingTable roamingTable = this.xmlRoamingTable.parseXML(inputStream);
        return new DefaultInternalRoamingTable(roamingTable, this.systemAttributes.getId(), remoteHostName, remoteHostAddress);
    }

    @Override
    public EnvironmentProperties getEnvironmentProperties() {
        return this.envPropertiesHolder.get();
    }

    public void connectionStatusChanged(ConnectionStatus status) {
        this.connectionStatus = status;
    }

    public void protocolTLSStatusChanged(boolean protocolTLSUsed) {
        this.protocolTLSEnabled = protocolTLSUsed;
    }

    public ContentProducer getRegisteredLabelsContentProducer(String stylesheet) {
        this.registeredLabelsContentProducer.setStylesheet(stylesheet);
        return this.registeredLabelsContentProducer;
    }

    @Override
    protected void updateServiceStatusDocument(DateTime now) {
        this.serviceStatus = this.createServiceStatus(now);
        this.serviceStatusDocument = this.xmlServiceStatus.toXML(this.serviceStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceStatus createInnerServiceStatus(DateTime now) {
        int uartErrors;
        int updateTaskTotalSize;
        int updateTaskCount;
        int waitingUpdateTasksCount;
        ServiceStatus serviceStatus = new ServiceStatus("Access Point");
        EnvironmentProperties envProperties = this.envPropertiesHolder.get();
        WirelessChannel channel = this.configurationManager.getWirelessConfiguration().getChannel();
        AccessPointThickServiceStatusUpdater accessPointThickServiceStatusUpdater = this;
        synchronized (accessPointThickServiceStatusUpdater) {
            waitingUpdateTasksCount = this.waitingUpdateTasksCount;
            updateTaskCount = this.updateTaskCount;
            updateTaskTotalSize = this.updateTaskTotalSize;
            uartErrors = this.uartErrors;
        }
        super.addCommonProperties(serviceStatus, channel, envProperties, now);
        super.addThinAP20SpecificProperties(serviceStatus);
        serviceStatus.setProperty("uart-errors", (long)uartErrors);
        serviceStatus.setProperty("waiting-tasks", (long)waitingUpdateTasksCount);
        serviceStatus.setProperty("tasks", (long)updateTaskCount);
        serviceStatus.setProperty("task-size", (long)updateTaskTotalSize);
        serviceStatus.setProperty("task-size-readable", ConversionUtils.toKiloByte((long)updateTaskTotalSize));
        serviceStatus.setProperty("server-hostname", this.roamingTable.getRemoteHostName());
        serviceStatus.setProperty("server-address", this.roamingTable.getRemoteHostAddress());
        serviceStatus.setProperty("roaming-table-valid", this.roamingTable.isValid());
        serviceStatus.setProperty("labels", (long)this.roamingTable.getAssignedLabelsCount());
        serviceStatus.setProperty("registered-labels", (long)this.roamingTable.getRegisteredLabelsCount());
        serviceStatus.setProperty("roaming-table-size", (long)this.roamingTable.getRegisteredLabelsCount());
        serviceStatus.setProperty("roaming-table-time", this.roamingTable.getUpdateTime());
        serviceStatus.setProperty("used-channels", this.roamingTable.getUsedChannelsString());
        serviceStatus.setProperty("roaming-valid-time", (long)this.roamingTable.getValidTimeInMinutes());
        serviceStatus.setProperty("ping-interval", (long)this.roamingTable.getPingIntervalInMinutes());
        serviceStatus.setProperty("sync-profile", this.roamingTable.getSyncProfile().toString());
        super.addJVMProperties(serviceStatus, envProperties, now);
        if (this.roamingTable.isAcceptAllLabels()) {
            serviceStatus.addProblem((Problem)MessageProblem.createWarning((String)"test-mode", (String)"Test mode: Access point accepts all join requests"));
        }
        if (!this.roamingTable.isValid()) {
            serviceStatus.addProblem((Problem)MessageProblem.createInfo((String)"no-roaming", (String)"Not connected to ESL server (no valid roaming information received)"));
        }
        if (channel == null) {
            serviceStatus.addProblem((Problem)MessageProblem.createWarning((String)"no-channel", (String)"No channel configured"));
        }
        super.addProblems(serviceStatus, now);
        return serviceStatus;
    }

    private ServiceStatus updateServiceStatus(ServiceStatus serviceStatus, LancomInfo lancomInfo) {
        if (lancomInfo == null) {
            lancomInfo = new LancomInfo();
        }
        if (this.isTcpLancom) {
            serviceStatus.setProperty("device-type", lancomInfo.getTypeIdentifier());
            serviceStatus.setProperty("transmitter-name", lancomInfo.getTypeIdentifier());
            serviceStatus.setProperty("transmitter-serial", lancomInfo.getSerial());
        } else {
            serviceStatus.setProperty("transmitter-name", lancomInfo.getTypeIdentifier());
            serviceStatus.setProperty("transmitter-serial", lancomInfo.getSerial());
            serviceStatus.setProperty("serial", lancomInfo.getSerial());
        }
        serviceStatus.setProperty("version", lancomInfo.getVersion().getVersionString());
        serviceStatus.setProperty("build", lancomInfo.getVersion() != null ? (long)lancomInfo.getVersion().getBuild() : 0L);
        return serviceStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServiceStatus createServiceStatus(DateTime now) {
        ServiceStatus serviceStatus = this.createInnerServiceStatus(now);
        if (this.mode == Mode.UDP || this.isTcpLancom) {
            Object object = this.lock;
            synchronized (object) {
                this.updateServiceStatus(serviceStatus, this.lancomInfo);
            }
        }
        return serviceStatus;
    }

    @Override
    protected void addThinAP20SpecificProperties(ServiceStatus serviceStatus) {
        if (this.mode != Mode.UDP) {
            super.addThinAP20SpecificProperties(serviceStatus);
        }
    }

    public synchronized void updateTasksAddedToRequestQueue(List<ExternalUpdateTask> tasks) {
        this.updateTaskCount += tasks.size();
        for (ExternalUpdateTask task : tasks) {
            this.updateTaskTotalSize += task.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLancomInformation(LancomInfo info) {
        Object object = this.lock;
        synchronized (object) {
            this.lancomInfo = info;
        }
    }

    public static enum Mode {
        UDP,
        OTHER;

    }
}

