/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointCommonDataListener;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.esl.msp.MSPStatusXMLUploader;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class AccessPointMSPStatusTask
implements ESLProcessingTask {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointMSPStatusTask.class);
    private final AccessPointConfigurationManager configurationManager;
    private final MSPStatusXMLUploader uploader;
    private final AccessPointCommonDataListener accessPointDataListener;
    private DateTime lastUploadTime = DateTime.now();

    public AccessPointMSPStatusTask(AccessPointCommonDataListener accessPointDataListener, AccessPointConfigurationManager configurationManager) throws InitializationException {
        this.accessPointDataListener = accessPointDataListener;
        this.configurationManager = configurationManager;
        this.uploader = new MSPStatusXMLUploader();
    }

    public void run() throws Exception {
        logger.debug("Running AccessPointMSPStatusTask");
        DateTime now = DateTime.now();
        MSPConfiguration mspConfiguration = this.configurationManager.getMspConfiguration();
        if (mspConfiguration.isEnabled() && Minutes.minutesBetween((ReadableInstant)this.lastUploadTime, (ReadableInstant)now).getMinutes() >= mspConfiguration.getUploadInterval()) {
            this.uploader.uploadToMSP(mspConfiguration, this.accessPointDataListener.getServiceStatus());
            this.lastUploadTime = now;
        }
    }
}

