/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointBaseServiceStatusUpdater;
import at.mrdevelopment.esl.accesspoint.AccessPointBasicCommonDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointCommonDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointMSPStatusTask;
import at.mrdevelopment.esl.accesspoint.AccessPointModule;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.CommunicationDaemonLogger;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.SendBroadcastTask;
import at.mrdevelopment.esl.accesspoint.SlotIdReaderStrategy;
import at.mrdevelopment.esl.accesspoint.SoftSynchronizer;
import at.mrdevelopment.esl.accesspoint.TimeoutLabelEvents;
import at.mrdevelopment.esl.accesspoint.TimeoutRoamingTableTask;
import at.mrdevelopment.esl.accesspoint.TimeoutUpdateTasks;
import at.mrdevelopment.esl.accesspoint.TimeoutWakeupStatisticsListenerTask;
import at.mrdevelopment.esl.accesspoint.UpdateRegisteredLabelDocumentTask;
import at.mrdevelopment.esl.accesspoint.UpdateServiceStatusTask;
import at.mrdevelopment.esl.accesspoint.http.AccessPointHttpServer;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointMode;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointThinMode;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.esl.accesspoint.tcp.APLocalSettingsReceiver;
import at.mrdevelopment.esl.accesspoint.tcp.ControlChannelHandler;
import at.mrdevelopment.esl.accesspoint.tcp.InfoPacketHolder;
import at.mrdevelopment.esl.accesspoint.tcp.SlotChannelHandler;
import at.mrdevelopment.esl.accesspoint.tcp.TCPControlChannelTask;
import at.mrdevelopment.esl.accesspoint.tcp.TCPHandleSlotChannelConnectionTask;
import at.mrdevelopment.esl.accesspoint.tcp.TCPSlotChannelTask;
import at.mrdevelopment.esl.accesspoint.tcp.TCPSlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.tcp.TCPWirelessTransmitter;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ProtectionLevel;
import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.admin.platform.config.storage.ConfigurationStorage;
import at.mrdevelopment.esl.certificate.ESLKeyStore;
import at.mrdevelopment.esl.certificate.ESLTrustManager;
import at.mrdevelopment.esl.certificate.ESLTrustStore;
import at.mrdevelopment.esl.core.DefaultPeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.ShutdownableShutdownHook;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AccessPointFactory {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointFactory.class);

    public AccessPointModule createAccessPoint(AccessPointBackendControl backendControl, ConfigurationStorage<AccessPointConfiguration> configurationStorage, AccessPointSystemAttributes systemAttributes, AccessPointConfigurationManager configurationManager, int port, boolean simulated, String firmwareFile) throws Exception {
        Info info = Info.load(AccessPoint.class);
        if (!simulated) {
            configurationManager.getTrustStoreConfiguration().apply();
        }
        if (configurationManager.getWebserviceConfiguration().isSSLEnabled() && !simulated) {
            ESLKeyStore.getInstance();
            ESLTrustStore.getInstance();
        }
        boolean thinApModeEnabled = configurationManager.getThinAPConfiguration().isModeEnabled();
        int remoteThinAPPort = configurationManager.getThinAPConfiguration().getPort();
        TCPCoreConfig tcpConfig = TCPCoreConfig.createAccessPointDefault();
        AccessPointRuntimeConfiguration runtimeConfiguration = new AccessPointRuntimeConfiguration(info, port, systemAttributes.getDeviceMode(), simulated);
        RequestQueue requestQueue = null;
        AccessPointCommonDataListener commonListener = null;
        AccessPointDataListener thickAccessPointListener = null;
        AccessPoint accessPoint = null;
        SlotPipeline slotPipeline = null;
        TCPCore tcpCore = new TCPCore(tcpConfig);
        ControlChannelHandler controlChannelHandler = null;
        InfoPacketHolder infoPacketHolder = new InfoPacketHolder();
        if (thinApModeEnabled) {
            commonListener = new AccessPointBasicCommonDataListener(configurationManager, systemAttributes, runtimeConfiguration);
        } else {
            requestQueue = new RequestQueue();
            accessPoint = new AccessPoint(configurationManager, systemAttributes, runtimeConfiguration, requestQueue, false, firmwareFile, false);
            slotPipeline = new SlotPipeline(16);
            thickAccessPointListener = new AccessPointDataListener(accessPoint, configurationManager, systemAttributes, runtimeConfiguration);
            requestQueue.registerUpdateTaskQueueListener(thickAccessPointListener.getServiceStatusListener());
            commonListener = thickAccessPointListener;
        }
        controlChannelHandler = new ControlChannelHandler(configurationManager, systemAttributes, runtimeConfiguration, infoPacketHolder);
        tcpCore.start();
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownableShutdownHook(new Shutdownable[]{tcpCore}));
        DefaultPeriodicTasksExecutor taskExecutor = new DefaultPeriodicTasksExecutor(){

            public long getReloadTime() {
                return 10000L;
            }
        };
        taskExecutor.addProcessingTask((ESLProcessingTask)new AccessPointMSPStatusTask(commonListener, configurationManager));
        taskExecutor.addProcessingTask((ESLProcessingTask)new SendBroadcastTask(commonListener, configurationManager, (SystemAttributes)systemAttributes, runtimeConfiguration));
        taskExecutor.addProcessingTask((ESLProcessingTask)new UpdateServiceStatusTask(commonListener));
        TCPControlChannelTask controlChannelTask = new TCPControlChannelTask(systemAttributes.getId(), tcpConfig, tcpCore, remoteThinAPPort, controlChannelHandler, configurationManager);
        if (commonListener instanceof AccessPointBasicCommonDataListener) {
            ((AccessPointBaseServiceStatusUpdater)((Object)commonListener)).setChannelStatusProvider(controlChannelTask);
            ((AccessPointBasicCommonDataListener)commonListener).setDaemonInfoProvider(controlChannelTask);
        } else {
            ((AccessPointDataListener)commonListener).setChannelStatusProvider(controlChannelTask);
            ((AccessPointDataListener)commonListener).setDaemonInfoProvider(controlChannelTask);
        }
        taskExecutor.addProcessingTask((ESLProcessingTask)controlChannelTask);
        if (!thinApModeEnabled) {
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutUpdateTasks(thickAccessPointListener, requestQueue));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutLabelEvents(thickAccessPointListener));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutWakeupStatisticsListenerTask(thickAccessPointListener.getWakeupStatisticsListener()));
            taskExecutor.addProcessingTask((ESLProcessingTask)new UpdateRegisteredLabelDocumentTask(thickAccessPointListener.getServiceStatusListener()));
            taskExecutor.addProcessingTask((ESLProcessingTask)new TimeoutRoamingTableTask(accessPoint));
            SoftSynchronizer softSynchronizer = new SoftSynchronizer(accessPoint.getAccessPointId());
            TCPSlotPipelineProcessing slotPipelineProcessing = new TCPSlotPipelineProcessing(accessPoint, slotPipeline, softSynchronizer);
            slotPipelineProcessing.startProcessingThread();
            Runtime.getRuntime().addShutdownHook((Thread)new ShutdownableShutdownHook(new Shutdownable[]{slotPipelineProcessing}));
            APLocalSettingsReceiver settingsReceiver = new APLocalSettingsReceiver(accessPoint);
            TCPSlotChannelTask slotChannelTask = new TCPSlotChannelTask(accessPoint.getAccessPointId(), tcpConfig, tcpCore, remoteThinAPPort);
            TCPWirelessTransmitter tcpWirelessTransmitter = new TCPWirelessTransmitter(slotPipeline, slotPipelineProcessing, softSynchronizer, accessPoint, systemAttributes.getId(), slotChannelTask, accessPoint, new SlotIdReaderStrategy(accessPoint), settingsReceiver);
            SlotChannelHandler slotChannelHandler = new SlotChannelHandler(systemAttributes.getId(), settingsReceiver, tcpWirelessTransmitter);
            slotChannelTask.setSlotChannelHandler(slotChannelHandler);
            slotChannelTask.setBinaryPacketDestination(tcpWirelessTransmitter);
            TCPHandleSlotChannelConnectionTask handleSlotConnectionTask = new TCPHandleSlotChannelConnectionTask(requestQueue, slotChannelTask);
            taskExecutor.addProcessingTask((ESLProcessingTask)handleSlotConnectionTask);
            taskExecutor.addProcessingTask((ESLProcessingTask)slotChannelTask);
        }
        ProtectionLevel protectionLevel = ((AccessPointConfiguration)configurationManager.getPlatformConfiguration()).getProtectionLevelConfiguration().getProtectionLevel();
        AccessPointHttpServer httpServer = new AccessPointHttpServer(accessPoint, AccessPointMode.createOnAccessPoint(thinApModeEnabled, AccessPointThinMode.TCP), thinApModeEnabled ? commonListener : thickAccessPointListener, requestQueue, backendControl, configurationManager, systemAttributes, runtimeConfiguration, null, infoPacketHolder, protectionLevel == ProtectionLevel.HIGH);
        if (configurationManager.getWebserviceConfiguration().isDefaultServicePortEnabled() || configurationManager.getWebserviceConfiguration().isDefaultServicePortSSL()) {
            httpServer.listen(port, configurationManager.getWebserviceConfiguration().isDefaultServicePortSSL(), 4, this.createSSLFactory(configurationManager.getWebserviceConfiguration().isDefaultServicePortSSL(), configurationManager.getSSLConfiguration()), configurationManager.getSSLConfiguration().isVerifyClientCertificates());
        }
        if (!simulated) {
            if (configurationManager.getWebserviceConfiguration().isHttpPortEnabled()) {
                try {
                    httpServer.listen(80, false, 4, null, false);
                }
                catch (WebserviceException exc) {
                    logger.warn("Could not create HTTP server on port 80 (%s)", new Object[]{exc.getMessage()});
                }
            }
            if (configurationManager.getWebserviceConfiguration().isHttpsPortEnabled() && !simulated) {
                httpServer.listen(443, true, 4, this.createSSLFactory(configurationManager.getWebserviceConfiguration().isDefaultServicePortSSL(), configurationManager.getSSLConfiguration()), configurationManager.getSSLConfiguration().isVerifyClientCertificates());
            }
            CommunicationDaemonLogger communicationDaemonLogger = new CommunicationDaemonLogger(4561);
            Runtime.getRuntime().addShutdownHook((Thread)new ShutdownableShutdownHook(new Shutdownable[]{communicationDaemonLogger}));
            communicationDaemonLogger.start();
        }
        taskExecutor.start();
        return new AccessPointModule(slotPipeline, accessPoint, (PeriodicTasksExecutor)taskExecutor, httpServer);
    }

    private SSLServerSocketFactory createSSLFactory(boolean useSSL, SSLConfiguration sslConfiguration) throws InitializationException {
        if (useSSL) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ESLKeyStore.getInstance().getKeyStore(), System.getProperty("javax.net.ssl.keyStorePassword").toCharArray());
                TrustManager[] trustManagers = new X509TrustManager[]{new ESLTrustManager(false, sslConfiguration.isVerifyClientCertificates())};
                sslContext.init(kmf.getKeyManagers(), trustManagers, null);
                return sslContext.getServerSocketFactory();
            }
            catch (NoSuchAlgorithmException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (KeyManagementException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (UnrecoverableKeyException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (KeyStoreException exc) {
                throw new InitializationException((Throwable)exc);
            }
        }
        return null;
    }
}

