/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointCommonDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.AccessPointThickServiceStatusUpdater;
import at.mrdevelopment.esl.accesspoint.AccessPointUpdateTasksListener;
import at.mrdevelopment.esl.accesspoint.AccessPointWakeupStatisticsListener;
import at.mrdevelopment.esl.accesspoint.AccessPointWakeupStatisticsListenerIF;
import at.mrdevelopment.esl.accesspoint.ChannelStatusProvider;
import at.mrdevelopment.esl.accesspoint.DaemonInfoProvider;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.JoinStatus;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.http.entity.ContentProducer;
import org.joda.time.DateTime;
import org.w3c.dom.Document;

public class AccessPointDataListener
implements AccessPointCommonDataListener {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointDataListener.class);
    private final AccessPointWakeupStatisticsListenerIF wakeupStatisticsListener;
    private final AccessPointUpdateTasksListener updateTasksListener;
    private final AccessPointThickServiceStatusUpdater serviceStatusListener;

    public AccessPointDataListener(AccessPoint accessPoint, AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration) throws InitializationException {
        this(accessPoint, configurationManager, systemAttributes, runtimeConfiguration, new AccessPointWakeupStatisticsListener(), new AccessPointThickServiceStatusUpdater(configurationManager, systemAttributes, runtimeConfiguration, accessPoint.isInitiallyOffline() ? ConnectionStatus.OFFLINE : ConnectionStatus.ONLINE));
    }

    protected AccessPointDataListener(AccessPoint accessPoint, AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, AccessPointWakeupStatisticsListenerIF wakeupStatisticsListener, AccessPointThickServiceStatusUpdater serviceStatusListener) throws InitializationException {
        this.wakeupStatisticsListener = wakeupStatisticsListener;
        accessPoint.registerWakeupListener(wakeupStatisticsListener);
        accessPoint.registerLabelEventListener(wakeupStatisticsListener);
        accessPoint.registerRoamingTableListener(wakeupStatisticsListener);
        this.updateTasksListener = new AccessPointUpdateTasksListener();
        accessPoint.registerAccessPointUpdateTaskListener(this.updateTasksListener);
        this.serviceStatusListener = serviceStatusListener;
        accessPoint.registerUpdateTaskListener(serviceStatusListener);
        accessPoint.registerRoamingTableListener(serviceStatusListener);
        accessPoint.registerAccessPointEventListener(serviceStatusListener);
    }

    public void setChannelStatusProvider(ChannelStatusProvider channelStatusProvider) {
        this.serviceStatusListener.setChannelStatusProvider(channelStatusProvider);
    }

    public void setDaemonInfoProvider(DaemonInfoProvider daemonInfoProvider) {
        this.serviceStatusListener.setDaemonInfoProvider(daemonInfoProvider);
    }

    public List<ExternalUpdateTask> parseUpdateTasks(InputStream inputStream) throws SerializeException {
        return this.updateTasksListener.parseUpdateTasks(inputStream);
    }

    public InternalRoamingTable parseRoamingTable(InputStream inputStream, String remoteHostName, String remoteHostAddress) throws SerializeException {
        return this.serviceStatusListener.parseRoamingTable(inputStream, remoteHostName, remoteHostAddress);
    }

    public boolean isAcceptAllLabels() {
        return this.wakeupStatisticsListener.isAcceptAllLabels();
    }

    public Collection<JoinRequest> getAllJoinRequests() {
        return this.wakeupStatisticsListener.getAllJoinRequests();
    }

    public Document getAllJoinRequestsDocument() {
        return this.wakeupStatisticsListener.getAllJoinRequestsDocument();
    }

    public Document getJoinRequestsWithJoinStatusDocument(JoinStatus joinStatus) {
        return this.wakeupStatisticsListener.getJoinRequestsWithJoinStatusDocument(joinStatus, 0);
    }

    public Document getJoinRequestsWithJoinStatusDocument(JoinStatus joinStatus, int withinSeconds) {
        return this.wakeupStatisticsListener.getJoinRequestsWithJoinStatusDocument(joinStatus, withinSeconds);
    }

    public Document getLabelEventsDocument() {
        return this.wakeupStatisticsListener.getLabelEventsDocument();
    }

    public Document getAssignedLabelsDocument() {
        return this.wakeupStatisticsListener.getAssignedLabelsDocument();
    }

    public Document getLabelsWithConnectionStatusDocument(ConnectionStatus connectionStatus) {
        return this.wakeupStatisticsListener.getLabelsWithConnectionStatusDocument(connectionStatus, false);
    }

    public Document getLabelsLastSeenWithinSecondsDocument(int lastSeenWithinSeconds) {
        return this.wakeupStatisticsListener.getLabelsLastSeenWithinSecondsDocument(lastSeenWithinSeconds);
    }

    public Document getLabelDocument(Address labelAddress) {
        return this.wakeupStatisticsListener.getLabelDocument(labelAddress);
    }

    public void timeoutLabelEvents(DateTime now, int validTimeInMinutes) {
        this.wakeupStatisticsListener.timeoutLabelEvents(now, validTimeInMinutes);
    }

    public List<ExternalUpdateTask> getUpdateTasks(Collection<UUID> taskIds) {
        return this.updateTasksListener.getUpdateTasks(taskIds);
    }

    public List<ExternalUpdateTask> getAllUpdateTasks() {
        return this.updateTasksListener.getAllUpdateTasks();
    }

    public List<ExternalUpdateTask> getTimedOutUpdateTasks(DateTime now, int validTimeInMinutes) {
        return this.updateTasksListener.getTimedOutUpdateTasks(now, validTimeInMinutes);
    }

    public Document getAllUpdateTasksDocument() {
        return this.updateTasksListener.getAllUpdateTasksDocument();
    }

    public Document getFinishedUpdateTasksDocument() {
        return this.updateTasksListener.getFinishedUpdateTasksDocument();
    }

    public Document getUpdateTaskDocument(UUID taskId) {
        return this.updateTasksListener.getUpdateTaskDocument(taskId);
    }

    @Override
    public Document getServiceStatusDocument() {
        return this.serviceStatusListener.getServiceStatusDocument();
    }

    @Override
    public ServiceStatus getServiceStatus() {
        return this.serviceStatusListener.getServiceStatus();
    }

    @Override
    public void updateServiceStatus(boolean fullUpdate) {
        this.serviceStatusListener.update(fullUpdate, DateTime.now());
    }

    @Override
    public EnvironmentProperties getEnvironmentProperties() {
        return this.serviceStatusListener.getEnvironmentProperties();
    }

    public void updateConnectionStatus(ConnectionStatus connectionStatus) {
        this.serviceStatusListener.connectionStatusChanged(connectionStatus);
    }

    public void updateProtocolUsingTLS(boolean usingTLS) {
        this.serviceStatusListener.protocolTLSStatusChanged(usingTLS);
    }

    public AccessPointWakeupStatisticsListenerIF getWakeupStatisticsListener() {
        return this.wakeupStatisticsListener;
    }

    public AccessPointUpdateTasksListener getUpdateTasksListener() {
        return this.updateTasksListener;
    }

    public AccessPointThickServiceStatusUpdater getServiceStatusListener() {
        return this.serviceStatusListener;
    }

    public ContentProducer getRegisteredLabelsContentProducer(String stylesheet) {
        return this.serviceStatusListener.getRegisteredLabelsContentProducer(stylesheet);
    }

    @Override
    public void update(boolean fullUpdate, DateTime now) {
        this.serviceStatusListener.update(fullUpdate, now);
    }
}

