/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.accesspoint.AccessPointProblem;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.AccessPointUpTimeParser;
import at.mrdevelopment.esl.accesspoint.ChannelStatus;
import at.mrdevelopment.esl.accesspoint.ChannelStatusProvider;
import at.mrdevelopment.esl.accesspoint.CommDaemonStatusDisplay;
import at.mrdevelopment.esl.accesspoint.DaemonInfoProvider;
import at.mrdevelopment.esl.accesspoint.ServiceStatusUpdater;
import at.mrdevelopment.esl.accesspoint.ThinAPVisibilityContext;
import at.mrdevelopment.esl.accesspoint.tcp.TCPAccessPointSettings;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.EnvironmentPropertiesHolder;
import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.xml.ServiceStatusXMLSerializer;
import at.mrdevelopment.toolkit.ConversionUtils;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.SystemInfo;
import at.mrdevelopment.toolkit.datetime.ReadableTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.BooleanUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.w3c.dom.Document;

public abstract class AccessPointBaseServiceStatusUpdater
implements ServiceStatusUpdater {
    protected final AccessPointUpTimeParser upTimeParser;
    protected final Map<AccessPointProblem, DateTime> problems;
    protected final ServiceStatusXMLSerializer xmlServiceStatus;
    protected final EnvironmentPropertiesHolder envPropertiesHolder = new EnvironmentPropertiesHolder();
    protected final AccessPointConfigurationManager configurationManager;
    protected final AccessPointSystemAttributes systemAttributes;
    protected final AccessPointRuntimeConfiguration runtimeConfiguration;
    protected final ThinAPVisibilityContext thinAPContext;
    protected volatile boolean protocolTLSEnabled = false;
    protected volatile ConnectionStatus connectionStatus;
    protected volatile SystemInfo systemInfo;
    protected volatile ServiceStatus serviceStatus;
    protected volatile Document serviceStatusDocument;
    protected volatile ChannelStatusProvider channelStatusProvider;
    protected volatile DaemonInfoProvider daemonInfoProvider;

    public AccessPointBaseServiceStatusUpdater(AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, ThinAPVisibilityContext thinAPContext, ConnectionStatus initialStatus) throws InitializationException {
        this.upTimeParser = new AccessPointUpTimeParser();
        this.problems = new ConcurrentHashMap<AccessPointProblem, DateTime>();
        this.xmlServiceStatus = new ServiceStatusXMLSerializer();
        this.systemInfo = new SystemInfo();
        this.connectionStatus = initialStatus;
        this.configurationManager = configurationManager;
        this.systemAttributes = systemAttributes;
        this.runtimeConfiguration = runtimeConfiguration;
        this.thinAPContext = thinAPContext;
    }

    public void setChannelStatusProvider(ChannelStatusProvider channelStatusProvider) {
        this.channelStatusProvider = channelStatusProvider;
    }

    public void setDaemonInfoProvider(DaemonInfoProvider daemonInfoProvider) {
        this.daemonInfoProvider = daemonInfoProvider;
    }

    @Override
    public Document getServiceStatusDocument() {
        return this.serviceStatusDocument;
    }

    @Override
    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    @Override
    public void update(boolean fullUpdate, DateTime now) {
        if (fullUpdate) {
            this.envPropertiesHolder.update();
        }
        this.updateServiceStatusDocument(now);
    }

    @Override
    public EnvironmentProperties getEnvironmentProperties() {
        return this.envPropertiesHolder.get();
    }

    protected void addCommonProperties(ServiceStatus serviceStatus, WirelessChannel channel, EnvironmentProperties envProperties, DateTime now) {
        serviceStatus.setProperty("ip-address", envProperties.getIPAddress());
        serviceStatus.setProperty("mac-address", envProperties.getMacAddress());
        serviceStatus.setProperty("netmask", envProperties.getSubnetMask());
        serviceStatus.setProperty("broadcast", envProperties.getBroadcast());
        serviceStatus.setProperty("os-type", envProperties.getOperatingSystem());
        serviceStatus.setProperty("uuid", envProperties.getUUID());
        serviceStatus.setProperty("adapter-name", envProperties.getAdapterName());
        serviceStatus.setProperty("hostname", this.configurationManager.getNetworkConfiguration().getHostName());
        serviceStatus.setProperty("device-type", this.systemAttributes.getDeviceTypeName());
        serviceStatus.setProperty("device-mode", this.systemAttributes.getDeviceMode().name());
        if (this.systemAttributes.getDeviceMode() == DeviceMode.ACCESSPOINT_2018) {
            serviceStatus.setProperty("device-model", this.systemAttributes.getDeviceModel().toString());
        }
        serviceStatus.setProperty("id", Integer.toString(this.systemAttributes.getId()));
        serviceStatus.setProperty("ssl-verify-client-certificates", String.valueOf(this.configurationManager.getSSLConfiguration().isVerifyClientCertificates()));
        serviceStatus.setProperty("version", this.runtimeConfiguration.getInfo().getVersion().toString());
        serviceStatus.setProperty("build", (long)this.runtimeConfiguration.getInfo().getVersion().getBuild());
        serviceStatus.setProperty("kernel-version", this.runtimeConfiguration.getKernelVersion().toString());
        serviceStatus.setProperty("kernel-build", (long)this.runtimeConfiguration.getKernelVersion().getBuild());
        if (this.systemAttributes.getDeviceMode() == DeviceMode.ACCESSPOINT) {
            serviceStatus.setProperty("bootloader-version", this.runtimeConfiguration.getBootLoaderVersion().toString());
            serviceStatus.setProperty("bootloader-build", (long)this.runtimeConfiguration.getBootLoaderVersion().getBuild());
            serviceStatus.setProperty("bootscript-version", this.runtimeConfiguration.getBootScriptVersion().toString());
            serviceStatus.setProperty("bootscript-build", (long)this.runtimeConfiguration.getBootScriptVersion().getBuild());
            serviceStatus.setProperty("busybox-version", this.runtimeConfiguration.getBusyboxVersion().toString());
        }
        serviceStatus.setProperty("serial", this.systemAttributes.getSerial());
        serviceStatus.setProperty("firmware-version", this.runtimeConfiguration.getFirmwareVersion().toString());
        serviceStatus.setProperty("extended-version", (long)this.runtimeConfiguration.getFirmwareVersion().getBuild());
        serviceStatus.setProperty("hardware-version", (long)this.systemAttributes.getRevision());
        serviceStatus.setProperty("hardware-revision", (long)this.systemAttributes.getRevision());
        serviceStatus.setProperty("status", this.connectionStatus.toString());
        serviceStatus.setProperty("channel", channel != null ? String.valueOf(channel.getChannelId()) : "");
        serviceStatus.setProperty("rf-power-mode", this.configurationManager.getWirelessConfiguration().getRadioOutputPowerLevel().name());
        serviceStatus.setProperty("window-size", (long)this.configurationManager.getWirelessConfiguration().getWindowSize());
        serviceStatus.setProperty("compliant-mode", this.configurationManager.getWirelessConfiguration().isFCCCompliant());
        serviceStatus.setProperty("forbid-join", String.valueOf(this.systemAttributes.isForbidJoin()));
        serviceStatus.setProperty("time", now);
        serviceStatus.setProperty("service-uptime", ReadableTimeFormatter.printElapsedTime((long)this.upTimeParser.getStartUpTime(), (long)this.upTimeParser.getCurrentUpTime()));
        serviceStatus.setProperty("auto-config", BooleanUtils.toString((Boolean)this.configurationManager.getAutoConfiguration().isEnabled(), (String)"true", (String)"false", (String)""));
    }

    protected void addJVMProperties(ServiceStatus serviceStatus, EnvironmentProperties envProperties, DateTime now) {
        serviceStatus.setProperty("java-runtime-version", this.systemInfo.getJavaRuntimeVersion());
        serviceStatus.setProperty("java-gc", envProperties.getGarbageCollector());
        serviceStatus.setProperty("max-memory", ConversionUtils.toMegaByte((long)Runtime.getRuntime().maxMemory()));
        serviceStatus.setProperty("free-memory", ConversionUtils.toMegaByte((long)Runtime.getRuntime().freeMemory()));
        serviceStatus.setProperty("total-memory", ConversionUtils.toMegaByte((long)Runtime.getRuntime().totalMemory()));
        serviceStatus.setProperty("threads", String.valueOf(Thread.activeCount()));
    }

    protected void addThinAP20SpecificProperties(ServiceStatus serviceStatus) {
        CommDaemonStatusDisplay daemonDisplay = this.thinAPContext.getDaemonStatusDisplay();
        if (daemonDisplay != CommDaemonStatusDisplay.NONE) {
            String daemonStatus = "OFFLINE";
            if (this.channelStatusProvider != null) {
                String slotRemoteEndpoint = this.channelStatusProvider.getSlotChannelRemoteEndpoint();
                if (daemonDisplay == CommDaemonStatusDisplay.FULL) {
                    if (this.channelStatusProvider.getControlChannelStatus() == ChannelStatus.CONNECTED) {
                        daemonStatus = slotRemoteEndpoint.isEmpty() ? "OPERATING" : "CONNECTED";
                    }
                    serviceStatus.setProperty("comm-daemon-remote-endpoint", slotRemoteEndpoint);
                } else if (!slotRemoteEndpoint.isEmpty()) {
                    daemonStatus = "CONNECTED";
                }
            } else if (daemonDisplay == CommDaemonStatusDisplay.FULL) {
                serviceStatus.setProperty("comm-daemon-remote-endpoint", "");
            }
            serviceStatus.setProperty("comm-daemon-status", daemonStatus);
            if (this.daemonInfoProvider != null) {
                Pair<String, String> data = this.daemonInfoProvider.getVersionAndDeviceType();
                serviceStatus.setProperty("comm-daemon-version", (String)data.getFirst());
                serviceStatus.setProperty("comm-daemon-device-type", (String)data.getSecond());
            } else {
                serviceStatus.setProperty("comm-daemon-version", "");
                serviceStatus.setProperty("comm-daemon-device-type", "");
            }
            if (daemonDisplay == CommDaemonStatusDisplay.SLOT_ONLY) {
                serviceStatus.setProperty("protocol-tls", this.protocolTLSEnabled);
                serviceStatus.setProperty("thinap-mode", true);
                TCPAccessPointSettings tcpApSettings = this.thinAPContext.getInitialTcpApSettings();
                boolean outboundModeEnabled = tcpApSettings.accessPointsUseOutboundMode();
                serviceStatus.setProperty("outbound-mode", outboundModeEnabled);
                if (outboundModeEnabled) {
                    serviceStatus.setProperty("apc-address", tcpApSettings.accessPointControllerAddress());
                    serviceStatus.setProperty("apc-port", (long)tcpApSettings.accessPointControllerPort());
                }
            } else {
                serviceStatus.setProperty("thinap-mode", false);
            }
        } else {
            serviceStatus.setProperty("thinap-mode", false);
        }
    }

    protected void addProblems(ServiceStatus serviceStatus, DateTime now) {
        for (Map.Entry<AccessPointProblem, DateTime> entry : this.problems.entrySet()) {
            AccessPointProblem problem = entry.getKey();
            DateTime reportTime = entry.getValue();
            if (!reportTime.plusMinutes(5).isAfter((ReadableInstant)now)) continue;
            serviceStatus.addProblem(problem.toProblem());
        }
    }

    protected void updateServiceStatusDocument(DateTime now) {
        this.serviceStatus = this.createServiceStatus(now);
        this.serviceStatusDocument = this.xmlServiceStatus.toXML(this.serviceStatus);
    }

    protected abstract ServiceStatus createServiceStatus(DateTime var1);
}

