/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointEventListener;
import at.mrdevelopment.esl.accesspoint.AccessPointEventNotifier;
import at.mrdevelopment.esl.accesspoint.AccessPointInterface;
import at.mrdevelopment.esl.accesspoint.AccessPointProblem;
import at.mrdevelopment.esl.accesspoint.AccessPointProcessingTask;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.AccessPointUpdateTasksListener;
import at.mrdevelopment.esl.accesspoint.DefaultInternalRoamingTable;
import at.mrdevelopment.esl.accesspoint.LabelEventNotifier;
import at.mrdevelopment.esl.accesspoint.LabelFeatures;
import at.mrdevelopment.esl.accesspoint.LabelStatusInfo;
import at.mrdevelopment.esl.accesspoint.LabelStatusStorage;
import at.mrdevelopment.esl.accesspoint.LegacyLabelTypeMapping;
import at.mrdevelopment.esl.accesspoint.ProtocolSettings;
import at.mrdevelopment.esl.accesspoint.ProtocolSettingsProvider;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.RoamingTableListener;
import at.mrdevelopment.esl.accesspoint.RoamingTableNotifier;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.TransmissionSettings;
import at.mrdevelopment.esl.accesspoint.request.AbortUpdateTaskRequest;
import at.mrdevelopment.esl.accesspoint.request.AddUpdateTasksRequest;
import at.mrdevelopment.esl.accesspoint.request.ClearRoamingTableRequest;
import at.mrdevelopment.esl.accesspoint.request.RemoveUpdateTaskRequest;
import at.mrdevelopment.esl.accesspoint.request.SetRoamingTableRequest;
import at.mrdevelopment.esl.accesspoint.request.WebserviceExecutionRequest;
import at.mrdevelopment.esl.accesspoint.taskqueue.WaitingUpdateTasks;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.JoinStatus;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.LabelEventListener;
import at.mrdevelopment.esl.core.TransmissionStatistic;
import at.mrdevelopment.esl.core.UpdateTaskListener;
import at.mrdevelopment.esl.core.UpdateTaskNotifier;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.core.WakeupListener;
import at.mrdevelopment.esl.core.WakeupNotifier;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.labeltype.LabelTypeMapping;
import at.mrdevelopment.esl.core.labeltype.LabelTypeResolver;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.firmware.FirmwareLoader;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.statistic.EventUtilization;
import at.mrdevelopment.esl.statistic.JoinRequestUtilization;
import at.mrdevelopment.esl.statistic.PacketSlotUtilization;
import at.mrdevelopment.esl.statistic.PipelineHazardRate;
import at.mrdevelopment.esl.statistic.SyncCommandUtilization;
import at.mrdevelopment.esl.statistic.UtilizationSource;
import at.mrdevelopment.esl.statistic.UtilizationSourceProvider;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.updatetask.AuxPageUpdateTask;
import at.mrdevelopment.esl.updatetask.CommandUpdateTask;
import at.mrdevelopment.esl.updatetask.DataUpdateTask;
import at.mrdevelopment.esl.updatetask.EventConfirmUpdateTask;
import at.mrdevelopment.esl.updatetask.ExternalDataUpdateTask;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.FirmwareUpdateTask;
import at.mrdevelopment.esl.updatetask.ImageUpdateTask;
import at.mrdevelopment.esl.updatetask.InternalPingUpdateTask;
import at.mrdevelopment.esl.updatetask.InternalUpdateTask;
import at.mrdevelopment.esl.updatetask.JoinUpdateTask;
import at.mrdevelopment.esl.updatetask.SetKeyUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UnlockLabelUpdateTask;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.InternalUpdateTaskCommit;
import at.mrdevelopment.esl.wireless.Ping;
import at.mrdevelopment.esl.wireless.RxMetrics;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.FirmwareVersionProvider;
import at.mrdevelopment.toolkit.HexFileFormat;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.encoding.NoEncoding;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.firmware.Firmware;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.time.DateTime;

public class AccessPoint
implements FirmwareVersionProvider,
AccessPointInterface,
WakeupNotifier,
LabelEventNotifier,
UpdateTaskNotifier,
RoamingTableNotifier,
AccessPointEventNotifier,
LabelTypeResolver,
InternalUpdateTaskCommit,
ProtocolSettingsProvider,
UtilizationSourceProvider {
    static ESLLogger logger = ESLLogger.getLogger(AccessPoint.class);
    public static final String APPLICATION_NAME = "SES-imagotag Access Point AP-2010";
    public static final String DEVICE_TYPE = "SES-imagotag Access Point AP-2010";
    private static final String UPLOADED_FIRMWARE_NAME = "firmware/fw_upload.xml";
    private static final int PING_TRY_INTERVAL_IN_MINUTES = 10;
    private static final int JOIN_TRY_INTERVAL_IN_MINUTES = 10;
    private static final int SET_KEY_TRY_INTERVAL_IN_MINUTES = 10;
    private static final DataEncoding NO_ENCODING = new NoEncoding();
    private static final Key PRESHARED_MASTER_KEY = Key.generateFromPassphrase((String)"27toh3o9e0raftuljf1qmmbci6v3rhrjktb19btkmk86ikp13k5ounr79bia0gg9q6nl58e5eo73r4cjcsfno23pddmbo76fpbpokv5");
    private final RequestQueue requestQueue;
    private final LabelStatusStorage labelStatusStorage;
    private final WaitingUpdateTasks waitingUpdateTasks = new WaitingUpdateTasks(1024, this);
    private final SyncCommandUtilization syncCommandUtilization = new SyncCommandUtilization();
    private final JoinRequestUtilization joinRequestUtilization = new JoinRequestUtilization();
    private final EventUtilization eventUtilization = new EventUtilization();
    private final PacketSlotUtilization packetSlotUtilization = new PacketSlotUtilization();
    private final PipelineHazardRate pipelineHazardRate = new PipelineHazardRate();
    private final Collection<UtilizationSource> utilizationSources = Collections.unmodifiableCollection(Arrays.asList(this.syncCommandUtilization, this.joinRequestUtilization, this.eventUtilization, this.packetSlotUtilization, this.pipelineHazardRate));
    private final List<WakeupListener> wakeupListeners = new CopyOnWriteArrayList<WakeupListener>();
    private final List<LabelEventListener> labelEventListeners = new CopyOnWriteArrayList<LabelEventListener>();
    private final List<UpdateTaskListener> updateTaskListeners = new CopyOnWriteArrayList<UpdateTaskListener>();
    private final List<RoamingTableListener> roamingTableListeners = new CopyOnWriteArrayList<RoamingTableListener>();
    private final List<AccessPointEventListener> accessPointEventListener = new CopyOnWriteArrayList<AccessPointEventListener>();
    private final List<AccessPointProcessingTask> processingTasks = new ArrayList<AccessPointProcessingTask>();
    private final AccessPointConfigurationManager configurationManager;
    private final AccessPointSystemAttributes systemAttributes;
    private final AccessPointRuntimeConfiguration runtimeConfiguration;
    private final Firmware transmitterFirmware;
    private final LabelTypeMapping labelTypeMapping = new LegacyLabelTypeMapping();
    private volatile InternalRoamingTable roamingTable;
    private final boolean initiallyOffline;
    private final boolean useImprovedTransmissionSettings;
    private AccessPointUpdateTasksListener updateTaskListener;

    public AccessPoint(AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, RequestQueue requestQueue, boolean initiallyOffline, boolean useImprovedTransmissionSettings) throws InitializationException {
        this(configurationManager, systemAttributes, runtimeConfiguration, requestQueue, initiallyOffline, "firmware.xml", useImprovedTransmissionSettings);
    }

    public AccessPoint(AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, RequestQueue requestQueue, boolean initiallyOffline, String firmwareFile, boolean useImprovedTransmissionSettings) throws InitializationException {
        this.configurationManager = configurationManager;
        this.requestQueue = requestQueue;
        this.labelStatusStorage = new LabelStatusStorage(systemAttributes.getId());
        this.systemAttributes = systemAttributes;
        this.runtimeConfiguration = runtimeConfiguration;
        this.transmitterFirmware = this.loadFirmware(firmwareFile);
        this.initiallyOffline = initiallyOffline;
        this.useImprovedTransmissionSettings = useImprovedTransmissionSettings;
        this.addProcessingTask(new AccessPointProcessingTask(){

            @Override
            public void run(SlotId slotId, DateTime now) throws Exception {
                if (slotId.isEmptySlot()) {
                    logger.info("%d waiting data update tasks", new Object[]{AccessPoint.this.waitingUpdateTasks.getDataUpdateTaskCount()});
                    logger.info("%d waiting command update tasks", new Object[]{AccessPoint.this.waitingUpdateTasks.getCommandUpdateTaskCount()});
                }
            }
        });
        this.roamingTable = new DefaultInternalRoamingTable();
    }

    public String getName() {
        return String.format("AP %d: ", this.getAccessPointId());
    }

    public Collection<UtilizationSource> getUtilizationSources() {
        return this.utilizationSources;
    }

    @Override
    public ProtocolSettings getProtocolSettings() {
        int accessPointId = this.getAccessPointId();
        int protocolId = this.roamingTable.getProtocoId();
        WirelessConfiguration wirelessConfiguration = this.configurationManager.getWirelessConfiguration();
        Set usedChannels = this.roamingTable.getUsedChannels();
        SyncProfile syncProfile = this.roamingTable.getSyncProfile();
        boolean identifyModeEnabled = this.runtimeConfiguration.isIdentifyModeEnabled();
        boolean joinForbidden = this.systemAttributes.isForbidJoin();
        boolean syncEnabled = this.roamingTable.isValid();
        return new ProtocolSettings(accessPointId, protocolId, syncProfile, wirelessConfiguration, usedChannels, syncEnabled, identifyModeEnabled, joinForbidden);
    }

    public Key getKeyForUpdateTask(DataUpdateTask updateTask) {
        Address labelAddress = updateTask.getAddress();
        if (updateTask instanceof SetKeyUpdateTask) {
            SetKeyUpdateTask setKeyUpdateTask = (SetKeyUpdateTask)updateTask;
            return this.getInitializationKey(labelAddress, setKeyUpdateTask.getPin());
        }
        if (updateTask instanceof UnlockLabelUpdateTask) {
            UnlockLabelUpdateTask unlockLabelUpdateTask = (UnlockLabelUpdateTask)updateTask;
            return this.getUnlockKey(unlockLabelUpdateTask.getPuk());
        }
        LabelStatusInfo labelStatusInfo = this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress);
        if (labelStatusInfo.useSecurity()) {
            if (updateTask instanceof ImageUpdateTask) {
                return this.getCommunicationKey(labelAddress);
            }
            if (updateTask instanceof FirmwareUpdateTask) {
                return this.getCommunicationKey(labelAddress);
            }
            if (updateTask instanceof AuxPageUpdateTask) {
                return this.getCommunicationKey(labelAddress);
            }
        } else if (labelStatusInfo.usePSKEncryption() && updateTask instanceof ExternalDataUpdateTask) {
            return this.getPresharedKey(labelAddress);
        }
        return null;
    }

    private Key getInitializationKey(Address address, Pin pin) {
        return Key.deriveFromKeyAndPin((Key)this.getPresharedKey(address), (Pin)pin);
    }

    private Key getCommunicationKey(Address labelAddress) {
        return Key.deriveFromKeyAndAddress((Key)this.roamingTable.getKey(), (Address)labelAddress);
    }

    private Key getUnlockKey(Puk puk) {
        return Key.deriveFromPuk((Puk)puk);
    }

    private Key getPresharedKey(Address labelAddress) {
        return Key.deriveFromKeyAndAddress((Key)PRESHARED_MASTER_KEY, (Address)labelAddress);
    }

    public void slotTimerTick(SlotId slotId, DateTime now) {
        this.performPeriodicTasks(slotId, now);
        ArrayList<Address> labelsInCurrentSlot = new ArrayList<Address>(this.roamingTable.getAssignedLabelsForSlot(slotId.getId()));
        Collections.shuffle(labelsInCurrentSlot);
        this.createRejoinsForAssignedLabels(labelsInCurrentSlot, now);
        this.createPingsForAssignedLabels(labelsInCurrentSlot, now);
        this.createSetKeysForAssignedLabels(labelsInCurrentSlot, now);
        this.processWebserviceRequests();
    }

    public void updateUtilizations(int usedSyncCommands, int usedJoinRequests, int usedEvents, int usedPacketSlots, boolean pipelineHazard, boolean transmissionFinished) {
        this.syncCommandUtilization.countCommands(usedSyncCommands);
        this.joinRequestUtilization.countJoinRequests(usedJoinRequests);
        this.eventUtilization.countEvents(usedEvents);
        this.packetSlotUtilization.countPacketSlots(usedPacketSlots);
        this.pipelineHazardRate.countPipelineHazard(pipelineHazard, transmissionFinished);
    }

    public void uartError() {
        this.notifyUartError();
    }

    public void reportProblem(AccessPointProblem problem) {
        this.notifyProblemDetected(problem);
    }

    public void prepareTaskImages(List<ExternalUpdateTask> updateTasks) {
        for (ExternalUpdateTask updateTask : updateTasks) {
            if (!(updateTask instanceof ImageUpdateTask)) continue;
            ImageUpdateTask imageUpdateTask = (ImageUpdateTask)updateTask;
            Address labelAddress = updateTask.getAddress();
            LabelType labelType = this.getLabelType(labelAddress);
            LabelFeatures labelFeatures = this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress).getLabelFeatures();
            DataEncoding encoding = this.roamingTable.isAcceptAllLabels() || labelType.isCompressionAllowed() && labelFeatures.isCompressionSupported() && imageUpdateTask.isCompressionAllowed() ? labelFeatures.getCompressionAlgorithm() : NO_ENCODING;
            try {
                imageUpdateTask.prepareCompressedDrivingData(labelType, encoding);
            }
            catch (SerializeException exc) {
                logger.error("%s: Failed to prepare image", new Object[]{updateTask.getAddress()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }

    public void processWebserviceRequests() {
        WebserviceExecutionRequest request = this.requestQueue.getRequest();
        if (request != null) {
            if (request instanceof AddUpdateTasksRequest) {
                AddUpdateTasksRequest addUpdateTaskRequest = (AddUpdateTasksRequest)request;
                this.addExternalUpdateTasks(addUpdateTaskRequest.getUpdateTasks());
            } else if (request instanceof RemoveUpdateTaskRequest) {
                RemoveUpdateTaskRequest removeUpdateTaskRequest = (RemoveUpdateTaskRequest)request;
                this.removeUpdateTasks(removeUpdateTaskRequest.getTaskIds());
            } else if (request instanceof AbortUpdateTaskRequest) {
                AbortUpdateTaskRequest abortUpdateTaskRequest = (AbortUpdateTaskRequest)request;
                this.abortUpdateTasks(abortUpdateTaskRequest.getTaskIds());
            } else if (request instanceof SetRoamingTableRequest) {
                SetRoamingTableRequest setRoamingTableRequest = (SetRoamingTableRequest)request;
                this.setRoamingTable(setRoamingTableRequest.getRoamingTable());
            } else if (request instanceof ClearRoamingTableRequest) {
                this.setRoamingTable(new DefaultInternalRoamingTable());
            } else {
                logger.warn("Ignoring unknown WebserviceExecutionRequest of type %s", new Object[]{request.getClass().getName()});
            }
        }
    }

    public void processPing(Address labelAddress, Ping ping, RxMetrics rxMetrics) {
        if (!labelAddress.isLabel()) {
            return;
        }
        WakeupStatistic wakeupStatistic = this.labelStatusStorage.processPing(labelAddress, ping, rxMetrics);
        this.notifyReceivedWakeup(wakeupStatistic);
    }

    public void joinRequested(Address labelAddress, DateTime now) {
        LabelStatusInfo labelStatusInfo = this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress);
        if (logger.isDebugEnabled()) {
            logger.debug("Join request from label: %s.", new Object[]{labelAddress.toString()});
        }
        if (labelStatusInfo.isJoinPending()) {
            logger.info("Join already pending for label %s", new Object[]{labelAddress});
            return;
        }
        boolean accept = this.roamingTable.isLabelRegistered(labelAddress);
        Set usedChannels = accept ? this.roamingTable.getUsedChannels() : Collections.emptySet();
        JoinUpdateTask updateTask = new JoinUpdateTask(labelAddress, accept, usedChannels, now);
        this.addUpdateTask((UpdateTask)updateTask);
        this.labelStatusStorage.joinRequested(labelAddress, now);
        JoinRequest joinRequest = new JoinRequest(labelAddress, this.getAccessPointId(), now, JoinStatus.DISCOVERED);
        this.notifyReceivedJoinRequest(joinRequest);
    }

    public void joinCommitted(Address labelAddress, DateTime now, boolean accept) {
        logger.info("Committed join request from %s", new Object[]{labelAddress});
        JoinStatus joinStatus = accept ? JoinStatus.ACCEPTED : JoinStatus.REJECTED;
        JoinRequest joinRequest = new JoinRequest(labelAddress, this.getAccessPointId(), now, joinStatus);
        this.notifyReceivedJoinRequest(joinRequest);
        this.labelStatusStorage.joinCommitted(labelAddress, now);
    }

    public void joinFailed(Address labelAddress, DateTime now) {
        logger.info("Fail join request from %s", new Object[]{labelAddress});
        JoinRequest joinRequest = new JoinRequest(labelAddress, this.getAccessPointId(), now, JoinStatus.FAILED);
        this.notifyReceivedJoinRequest(joinRequest);
        this.labelStatusStorage.joinFailed(labelAddress);
    }

    public void eventReceived(Address labelAddress, int type, int data, DateTime now) {
        LabelStatusInfo labelStatusInfo = this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress);
        if (labelStatusInfo.isEventConfirmPending()) {
            logger.info("Event confirm already pending for label %s", new Object[]{labelAddress});
            return;
        }
        EventConfirmUpdateTask updateTask = new EventConfirmUpdateTask(labelAddress, type);
        this.addUpdateTask((UpdateTask)updateTask);
        this.labelStatusStorage.eventReceived(labelAddress);
        LabelEvent labelEvent = new LabelEvent(UUID.randomUUID(), labelAddress, now, type, data);
        this.notifyReceivedLabelEvent(labelEvent);
    }

    public void eventCommitted(Address labelAddress, DateTime now) {
        logger.info("Committed event from %s", new Object[]{labelAddress});
        this.labelStatusStorage.eventCommitted(labelAddress);
        this.notifyReceivedLabelEventConfirm(labelAddress);
    }

    public void eventFailed(Address labelAddress, DateTime now) {
        logger.info("Failed event from %s", new Object[]{labelAddress});
        this.labelStatusStorage.eventFailed(labelAddress);
    }

    public void setKeyCommitted(Address labelAddress, DateTime now) {
        this.updateLabelKeyStatus(labelAddress, false, now);
        this.labelStatusStorage.setKeyCommitted(labelAddress, now);
    }

    public void setKeyFailed(Address labelAddress, DateTime now) {
        logger.info("Failed set key from %s", new Object[]{labelAddress});
        this.labelStatusStorage.setKeyFailed(labelAddress, now);
    }

    public void labelUpdateFinished(UpdateTask updateTask, UpdateTaskStatus status, UpdateError updateError, TransmissionStatistic transmissionStatistic, DateTime now) {
        Address labelAddress = updateTask.getAddress();
        if (updateTask instanceof InternalUpdateTask) {
            InternalUpdateTask internalUpdateTask = (InternalUpdateTask)updateTask;
            if (status.isSuccessful()) {
                internalUpdateTask.taskCommitted((InternalUpdateTaskCommit)this, now);
            } else if (internalUpdateTask.hasRetriesLeft()) {
                if (updateError != null && updateError.isClearRetries()) {
                    logger.info("Failed task %s to label %s with status %s (error=%s, no retries)", new Object[]{internalUpdateTask.getClass().getSimpleName(), updateTask.getAddress(), status, updateError});
                    internalUpdateTask.taskFailed((InternalUpdateTaskCommit)this, now);
                } else {
                    logger.info("Create retry for %s to label %s with status %s (error=%s, retriesLeft=%d)", new Object[]{internalUpdateTask.getClass().getSimpleName(), updateTask.getAddress(), status, updateError, internalUpdateTask.getRetriesLeft()});
                    InternalUpdateTask retryUpdateTask = internalUpdateTask.createRetry();
                    this.addUpdateTask((UpdateTask)retryUpdateTask);
                }
            } else {
                logger.info("Failed all retries for task %s to label %s with last status %s (error=%s)", new Object[]{internalUpdateTask.getClass().getSimpleName(), updateTask.getAddress(), status, updateError});
                internalUpdateTask.taskFailed((InternalUpdateTaskCommit)this, now);
            }
        } else if (updateTask instanceof ExternalUpdateTask) {
            ExternalUpdateTask externalUpdateTask;
            if (updateTask instanceof UnlockLabelUpdateTask && status.isSuccessful()) {
                this.updateLabelKeyStatus(labelAddress, true, now);
            }
            if (!(externalUpdateTask = (ExternalUpdateTask)updateTask).isCanceled()) {
                externalUpdateTask.changeStatus(status, updateError, transmissionStatistic);
                this.notifyUpdateTaskChanged(externalUpdateTask);
            }
        }
    }

    public LabelType getLabelType(Address labelAddress) {
        LabelType labelType = this.roamingTable.getLabelType(labelAddress);
        return labelType != null ? labelType : this.labelTypeMapping.getTypeForLabelId(labelAddress.getHardwareAddress());
    }

    public Firmware getFirmware() {
        return this.transmitterFirmware;
    }

    public boolean isNewFirmwareAvailable(Version currentFirmwareVersion) {
        return this.transmitterFirmware != null ? this.transmitterFirmware.getVersion().isNewer(currentFirmwareVersion) : false;
    }

    public Version getFirmwareVersion() {
        return this.runtimeConfiguration.getFirmwareVersion();
    }

    public void setFirmwareVersion(Version firmwareVersion) {
        this.runtimeConfiguration.setFirmwareVersion(firmwareVersion);
    }

    public Version getSoftwareVersion() {
        return this.runtimeConfiguration.getInfo().getVersion();
    }

    @Override
    public int getAccessPointId() {
        return this.systemAttributes.getId();
    }

    private void addExternalUpdateTasks(Collection<? extends ExternalUpdateTask> updateTasks) {
        for (ExternalUpdateTask externalUpdateTask : updateTasks) {
            this.addExternalUpdateTask(externalUpdateTask);
        }
        this.notifyTasksAdded();
    }

    private void addExternalUpdateTask(ExternalUpdateTask updateTask) {
        this.addUpdateTask((UpdateTask)updateTask);
        this.notifyUpdateTaskAdded(updateTask);
    }

    private void addUpdateTask(UpdateTask updateTask) {
        Address labelAddress = updateTask.getAddress();
        int slotId = labelAddress.getSlot();
        LabelFeatures labelFeatures = this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress).getLabelFeatures();
        if (logger.isDebugEnabled()) {
            logger.debug("Adding %s to label with %s with features %s", new Object[]{updateTask.getClass().getSimpleName(), labelAddress, labelFeatures});
        }
        this.waitingUpdateTasks.addUpdateTask(slotId, updateTask, labelFeatures);
    }

    private void setRoamingTable(InternalRoamingTable roamingTable) {
        this.roamingTable = roamingTable;
        this.notifyRoamingTableChanged(roamingTable);
    }

    public DataUpdateTask queryDataUpdateTask(SlotId slotId, TaskPriority priority, DateTime now) {
        return this.queryUpdateTask(this.waitingUpdateTasks.queryDataUpdateTask(slotId, priority, this.roamingTable.getSyncProfile()), now);
    }

    public CommandUpdateTask queryCommandUpdateTask(SlotId slotId, TaskPriority priority, Address blockedLabelAddress, DateTime now) {
        return this.queryUpdateTask(this.waitingUpdateTasks.queryCommandUpdateTask(slotId, priority, blockedLabelAddress, this.roamingTable.getSyncProfile()), now);
    }

    private <T extends UpdateTask> T queryUpdateTask(T updateTask, DateTime now) {
        if (updateTask == null) {
            return null;
        }
        if (updateTask instanceof ExternalUpdateTask) {
            ExternalUpdateTask externalUpdateTask = (ExternalUpdateTask)updateTask;
            if (externalUpdateTask.isFinished()) {
                if (externalUpdateTask.isCanceled()) {
                    logger.info("Update task %s to label %s was canceled", new Object[]{externalUpdateTask.getTaskId(), externalUpdateTask.getAddress()});
                } else {
                    logger.error("Update task %s to label %s has unexpected status %s", new Object[]{externalUpdateTask.getTaskId(), externalUpdateTask.getAddress(), externalUpdateTask.getStatus()});
                }
                return null;
            }
            if (this.roamingTable.isEncryptionRequired() && this.labelStatusStorage.getOrCreateLabelStatusInfo(updateTask.getAddress()).isKeyUnset()) {
                TransmissionStatistic transmissionStatistic = TransmissionStatistic.timeOnly((int)59);
                this.labelUpdateFinished(updateTask, UpdateTaskStatus.ERROR, UpdateError.ERROR_CODE_AUTHENTICATION_FAILED, transmissionStatistic, now);
                return null;
            }
        }
        if (updateTask.isRegistrationRequired() && !this.roamingTable.isAcceptAllLabels() && !this.roamingTable.isLabelRegistered(updateTask.getAddress())) {
            TransmissionStatistic transmissionStatistic = TransmissionStatistic.timeOnly((int)59);
            this.labelUpdateFinished(updateTask, UpdateTaskStatus.ERROR, UpdateError.ERROR_CODE_UNREGISTERED, transmissionStatistic, now);
            return null;
        }
        return updateTask;
    }

    private void removeUpdateTasks(Collection<UUID> taskIds) {
        List<ExternalUpdateTask> updateTasks = this.updateTaskListener.getUpdateTasks(taskIds);
        logger.info("Removing %d tasks", new Object[]{updateTasks.size()});
        for (ExternalUpdateTask updateTask : updateTasks) {
            this.removeUpdateTask(updateTask);
        }
    }

    private void removeUpdateTask(ExternalUpdateTask updateTask) {
        if (updateTask != null) {
            if (updateTask.isFinished()) {
                logger.info("Removing update task %s in status %s", new Object[]{updateTask.getTaskId(), updateTask.getStatus()});
                this.notifyUpdateTaskRemoved(updateTask);
            } else {
                logger.info("Failed to remove update task %s in status %s", new Object[]{updateTask.getTaskId(), updateTask.getStatus()});
            }
        } else {
            logger.info("Failed to remove update task: Task not found");
        }
    }

    private void abortUpdateTasks(Collection<UUID> taskIds) {
        List<ExternalUpdateTask> updateTasks = this.updateTaskListener.getUpdateTasks(taskIds);
        logger.info("Aborting %d tasks", new Object[]{updateTasks.size()});
        for (ExternalUpdateTask updateTask : updateTasks) {
            this.abortUpdateTask(updateTask);
        }
    }

    private void abortUpdateTask(ExternalUpdateTask updateTask) {
        if (updateTask.isWaiting()) {
            logger.info("Aborting update task %s", new Object[]{updateTask.getTaskId()});
            updateTask.changeStatus(UpdateTaskStatus.CANCELED, null);
            this.notifyUpdateTaskChanged(updateTask);
        } else {
            logger.info("Failed to abort update task %s in status %s", new Object[]{updateTask.getTaskId(), updateTask.getStatus()});
        }
    }

    public void shutdown() {
        logger.info("Access point terminated");
    }

    public void registerWakeupListener(WakeupListener listener) {
        this.wakeupListeners.add(listener);
    }

    public void unregisterWakeupListener(WakeupListener listener) {
        this.wakeupListeners.remove(listener);
    }

    @Override
    public void registerLabelEventListener(LabelEventListener listener) {
        this.labelEventListeners.add(listener);
    }

    @Override
    public void unregisterLabelEventListener(LabelEventListener listener) {
        this.labelEventListeners.remove(listener);
    }

    public void registerUpdateTaskListener(UpdateTaskListener listener) {
        this.updateTaskListeners.add(listener);
    }

    public void unregisterUpdateTaskListener(UpdateTaskListener listener) {
        this.updateTaskListeners.remove(listener);
    }

    @Override
    public void registerRoamingTableListener(RoamingTableListener listener) {
        this.roamingTableListeners.add(listener);
    }

    @Override
    public void unregisterRoamingTableListener(RoamingTableListener listener) {
        this.roamingTableListeners.remove(listener);
    }

    @Override
    public void registerAccessPointEventListener(AccessPointEventListener listener) {
        this.accessPointEventListener.add(listener);
    }

    @Override
    public void unregisterAccessPointEventListener(AccessPointEventListener listener) {
        this.accessPointEventListener.remove(listener);
    }

    public void notifyReceivedWakeup(WakeupStatistic wakeupStatistic) {
        for (WakeupListener listener : this.wakeupListeners) {
            listener.receivedWakeup(wakeupStatistic);
        }
    }

    public void notifyReceivedJoinRequest(JoinRequest joinRequest) {
        for (WakeupListener listener : this.wakeupListeners) {
            listener.receivedJoinRequest(joinRequest);
        }
    }

    private void notifyReceivedLabelEvent(LabelEvent labelEvent) {
        for (LabelEventListener listener : this.labelEventListeners) {
            listener.receivedLabelEvent(labelEvent);
        }
    }

    private void notifyReceivedLabelEventConfirm(Address labelAddress) {
        for (LabelEventListener listener : this.labelEventListeners) {
            listener.receivedEventConfirm(labelAddress);
        }
    }

    private void notifyUpdateTaskAdded(ExternalUpdateTask updateTask) {
        for (UpdateTaskListener listener : this.updateTaskListeners) {
            listener.updateTaskAdded(updateTask);
        }
    }

    private void notifyUpdateTaskChanged(ExternalUpdateTask updateTask) {
        for (UpdateTaskListener listener : this.updateTaskListeners) {
            listener.updateTaskChanged(updateTask);
        }
    }

    private void notifyUpdateTaskRemoved(ExternalUpdateTask updateTask) {
        for (UpdateTaskListener listener : this.updateTaskListeners) {
            listener.updateTaskRemoved(updateTask);
        }
    }

    private void notifyRoamingTableChanged(InternalRoamingTable roamingTable) {
        for (RoamingTableListener listener : this.roamingTableListeners) {
            listener.roamingTableChanged(roamingTable);
        }
    }

    private void notifyTasksAdded() {
        for (AccessPointEventListener listener : this.accessPointEventListener) {
            listener.tasksAdded();
        }
    }

    private void notifyProblemDetected(AccessPointProblem problem) {
        for (AccessPointEventListener listener : this.accessPointEventListener) {
            listener.problemDetected(problem);
        }
    }

    private void notifyUartError() {
        for (AccessPointEventListener listener : this.accessPointEventListener) {
            listener.uartError();
        }
    }

    public void performPeriodicTasks(SlotId slotId, DateTime now) {
        for (AccessPointProcessingTask task : this.processingTasks) {
            try {
                task.run(slotId, now);
            }
            catch (Exception exc) {
                logger.error(exc.getMessage());
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }

    public void timeoutRoamingTable(DateTime now) {
        if (this.roamingTable.isValid() && this.roamingTable.isTimedOut(now)) {
            logger.info("Roaming table from %s timed out.", new Object[]{this.roamingTable.getRemoteHostAddress()});
            this.setRoamingTable(new DefaultInternalRoamingTable());
        }
    }

    private void addProcessingTask(AccessPointProcessingTask task) {
        this.processingTasks.add(task);
    }

    private void updateLabelKeyStatus(Address labelAddress, boolean keyUnset, DateTime now) {
        logger.info("Setting keyUnset for label %s to %b", new Object[]{labelAddress, keyUnset});
        WakeupStatistic wakeupStatistic = this.labelStatusStorage.markKeyUnset(labelAddress, keyUnset);
        this.notifyReceivedWakeup(wakeupStatistic);
    }

    private void createPingsForAssignedLabels(Iterable<Address> labelsInCurrentSlot, DateTime now) {
        for (Address labelAddress : labelsInCurrentSlot) {
            LabelStatusInfo labelStatusInfo = this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress);
            if (labelStatusInfo.isPingPending() || labelStatusInfo.getMinutesSinceLastPingReply(now).getMinutes() < this.roamingTable.getPingIntervalInMinutes() || labelStatusInfo.getMinutesSinceLastPingRequest(now).getMinutes() < 10) continue;
            logger.info("Scheduling ping on label %s", new Object[]{labelAddress});
            InternalPingUpdateTask updateTask = new InternalPingUpdateTask(labelAddress);
            this.addUpdateTask((UpdateTask)updateTask);
            this.labelStatusStorage.pingRequestScheduled(labelAddress, now);
        }
    }

    private void createRejoinsForAssignedLabels(Iterable<Address> labelsInCurrentSlot, DateTime now) {
        Set usedChannels = this.roamingTable.getUsedChannels();
        for (Address labelAddress : labelsInCurrentSlot) {
            LabelStatusInfo labelStatusInfo = this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress);
            int joinIntervalInMinutes = labelStatusInfo.getLabelFeatures().getJoinIntervalInMinutes();
            if (labelStatusInfo.isJoinPending() || labelStatusInfo.getMinutesSinceLastJoinCommit(now).getMinutes() < joinIntervalInMinutes || labelStatusInfo.getMinutesSinceLastJoinRequest(now).getMinutes() < 10) continue;
            logger.info("Scheduling rejoin on label %s", new Object[]{labelAddress});
            JoinUpdateTask updateTask = new JoinUpdateTask(labelAddress, true, usedChannels, now);
            this.addUpdateTask((UpdateTask)updateTask);
            this.labelStatusStorage.joinRequested(labelAddress, now);
            JoinRequest joinRequest = new JoinRequest(labelAddress, this.getAccessPointId(), now, JoinStatus.REJOINED);
            this.notifyReceivedJoinRequest(joinRequest);
        }
    }

    private void createSetKeysForAssignedLabels(Iterable<Address> labelsInCurrentSlot, DateTime now) {
        for (Address labelAddress : labelsInCurrentSlot) {
            LabelStatusInfo labelStatusInfo = this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress);
            if (labelStatusInfo.isSetKeyPending()) continue;
            WakeupStatistic wakeupStatistic = labelStatusInfo.getWakeupStatistic();
            LabelFeatures labelFeatures = labelStatusInfo.getLabelFeatures();
            logger.info("Checking security status for label %s: securitySupported=%b; keyUnset=%b; keysNotProgrammed=%b; hasPin=%b; hasNetworkKey=%b", new Object[]{labelAddress, labelFeatures.isSecuritySupported(), wakeupStatistic.isKeyUnset(), wakeupStatistic.areKeysNotProgrammed(), this.roamingTable.hasPin(labelAddress), this.roamingTable.hasKey()});
            Key key = this.roamingTable.getKey();
            Pin pin = this.roamingTable.getPin(labelAddress);
            boolean validSecurityConfiguration = key != null && !key.isEmptyKey() && pin != null;
            if (!validSecurityConfiguration || !labelFeatures.isSecuritySupported() || !wakeupStatistic.canReceiveKey() || labelStatusInfo.getMinutesSinceLastSetKey(now).getMinutes() < 10) continue;
            logger.info("Scheduling set key on label %s", new Object[]{labelAddress});
            Key communicationKey = this.getCommunicationKey(labelAddress);
            SetKeyUpdateTask updateTask = new SetKeyUpdateTask(labelAddress, pin, communicationKey);
            this.addUpdateTask((UpdateTask)updateTask);
            this.labelStatusStorage.setKeyScheduled(labelAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Firmware loadFirmware(String firmwareFile) throws InitializationException {
        File uploadedFirmware = new File(UPLOADED_FIRMWARE_NAME);
        if (uploadedFirmware.exists()) {
            try {
                Firmware firmware = this.loadFirmwareWithName(UPLOADED_FIRMWARE_NAME);
                Firmware firmware2 = firmware = new Firmware(firmware.getFirmwareImage(), true);
                return firmware2;
            }
            catch (IOException exc) {
                logger.warn("Failed to read custom transmitter firmware image file");
            }
            catch (SerializeException exc) {
                logger.warn("Failed to parse custom transmitter firmware image file");
            }
            finally {
                FileUtils.deleteQuietly((File)uploadedFirmware);
            }
        }
        return this.loadDefaultFirmware(firmwareFile);
    }

    private Firmware loadDefaultFirmware(String firmwareFile) throws InitializationException {
        try {
            Firmware defaultFirmware = this.loadFirmwareWithName(firmwareFile);
            if (defaultFirmware.getForceUpdateFlag()) {
                logger.warn("Default firmware with force update flag found");
            }
            return defaultFirmware;
        }
        catch (IOException exc) {
            logger.warn("Failed to read default transmitter firmware image file");
        }
        catch (SerializeException exc) {
            logger.warn("Failed to parse default transmitter firmware image file");
        }
        return null;
    }

    private Firmware loadFirmwareWithName(String firmwareName) throws InitializationException, SerializeException, IOException {
        FirmwareLoader firmwareLoader = new FirmwareLoader();
        return firmwareLoader.loadFirmware(firmwareName, this.systemAttributes.getDeviceMode() == DeviceMode.ACCESSPOINT ? HexFileFormat.CC2510 : HexFileFormat.CC26XX);
    }

    public void pingFailed(Address labelAddress, DateTime now) {
        this.labelStatusStorage.pingFailed(labelAddress);
    }

    public boolean isInitiallyOffline() {
        return this.initiallyOffline;
    }

    public void registerAccessPointUpdateTaskListener(AccessPointUpdateTasksListener updateTasksListener) {
        this.updateTaskListener = updateTasksListener;
        this.registerUpdateTaskListener(updateTasksListener);
    }

    public TransmissionSettings getTransmissionSettings(Address labelAddress) {
        if (this.useImprovedTransmissionSettings) {
            return this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress).getLabelFeatures().getTransmissionSettings();
        }
        WirelessConfiguration wirelessConfiguration = this.configurationManager.getWirelessConfiguration();
        return new TransmissionSettings(wirelessConfiguration.getPayloadSize(), wirelessConfiguration.getWindowSize());
    }

    public LabelFeatures getLabelFeatures(Address labelAddress) {
        return this.labelStatusStorage.getOrCreateLabelStatusInfo(labelAddress).getLabelFeatures();
    }
}

