/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl;

import at.mrdevelopment.esl.accesspoint.AccessPointFactory;
import at.mrdevelopment.esl.accesspoint.AccessPointModule;
import at.mrdevelopment.esl.accesspoint.taskqueue.ImpreciseDateTimeProvider;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.DefaultAccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.DefaultAccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.admin.platform.config.storage.ConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.DefaultAccessPointConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.HSQLDBPlatformStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.core.ESLProperties;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.ShutdownableShutdownHook;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.net.SocketException;
import java.security.Provider;
import java.security.Security;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.log4j.MDC;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SerialAccessPoint {
    private static final int DEFAULT_TCP_LISTEN_PORT = 8080;
    private static final String FIRMWARE_FILE = "firmware.xml";
    static ESLLogger logger;

    public static void main(String[] args) {
        logger.info("Starting %s", new Object[]{"SES-imagotag Access Point AP-2010"});
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionPort = parser.accepts("port").withRequiredArg().ofType(Integer.class);
        OptionSet options = parser.parse(args);
        int port = options.has((OptionSpec)optionPort) ? (Integer)options.valueOf((OptionSpec)optionPort) : 8080;
        try {
            SerialAccessPoint.setCustomSSLProperties();
            HSQLDBPlatformStorage accessPointStorage = new HSQLDBPlatformStorage();
            DefaultAccessPointBackendControl backendControl = new DefaultAccessPointBackendControl((PlatformStorage)accessPointStorage, true);
            DefaultAccessPointConfigurationStorage configurationStorage = new DefaultAccessPointConfigurationStorage((PlatformStorage)accessPointStorage);
            DefaultAccessPointSystemAttributes systemAttributes = new DefaultAccessPointSystemAttributes((PlatformStorage)accessPointStorage, true, null);
            SerialAccessPoint.setProvisioningSSLProperties();
            AccessPointConfigurationManager configurationManager = new AccessPointConfigurationManager((BackendControl)backendControl, (ConfigurationStorage)configurationStorage);
            ImpreciseDateTimeProvider.createAndStart(1);
            AccessPointModule accessPointModule = new AccessPointFactory().createAccessPoint((AccessPointBackendControl)backendControl, (ConfigurationStorage<AccessPointConfiguration>)configurationStorage, (AccessPointSystemAttributes)systemAttributes, configurationManager, port, false, FIRMWARE_FILE);
            Runtime.getRuntime().addShutdownHook((Thread)new ShutdownableShutdownHook(new Shutdownable[]{accessPointModule, ImpreciseDateTimeProvider.getInstance()}));
            MDC.put((String)"AP_ID", (Object)String.valueOf(systemAttributes.getId()));
        }
        catch (SocketException exc) {
            logger.error("Could not create socket: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        catch (InitializationException exc) {
            logger.error("Error during imagotag Access Point initialization");
            logger.logException((Throwable)exc);
        }
        catch (Exception exc) {
            logger.error("Unknown error during startup of imagotag Access Point. See stack trace for details.");
            logger.logException((Throwable)exc);
        }
    }

    private static void setCustomSSLProperties() {
        System.setProperty("javax.net.ssl.keyStore", "/esl/security/certificate.keystore");
        System.setProperty("javax.net.ssl.trustStore", "/esl/security/certificate.truststore");
        ESLProperties.setKeyStore();
    }

    private static void setProvisioningSSLProperties() {
        System.setProperty("com.imagotag.ssl.provisioning.keyStore", "/esl/security/provisioning.keystore");
        ESLProperties.setProvisioningKeyStore((DeviceMode)DeviceMode.ACCESSPOINT);
    }

    static {
        MDC.put((String)"application", (Object)"accesspoint");
        ESLLogger.initLogger((boolean)false, (boolean)true);
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger = ESLLogger.getLogger(SerialAccessPoint.class);
    }
}

