/*
 * Decompiled with CFR 0.152.
 */
package socks.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import socks.InetRange;
import socks.ProxyMessage;
import socks.server.Ident;
import socks.server.ServerAuthenticator;
import socks.server.ServerAuthenticatorNone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentAuthenticator
extends ServerAuthenticatorNone {
    Vector<InetRange> hosts;
    Vector<Hashtable<String, Object>> users;
    String user;

    public IdentAuthenticator() {
        this.hosts = new Vector();
        this.users = new Vector();
    }

    IdentAuthenticator(InputStream in, OutputStream out, String user) {
        super(in, out);
        this.user = user;
    }

    public synchronized void add(InetRange hostRange, Hashtable<String, Object> users) {
        this.hosts.addElement(hostRange);
        this.users.addElement(users);
    }

    @Override
    public ServerAuthenticator startSession(Socket s) throws IOException {
        int ind = this.getRangeIndex(s.getInetAddress());
        String user = null;
        if (ind < 0) {
            return null;
        }
        ServerAuthenticatorNone auth = (ServerAuthenticatorNone)super.startSession(s);
        if (auth == null) {
            return null;
        }
        Hashtable<String, Object> user_names = this.users.elementAt(ind);
        if (user_names != null) {
            Ident ident = new Ident(s);
            if (!ident.successful) {
                return null;
            }
            if (!user_names.containsKey(ident.userName)) {
                return null;
            }
            user = ident.userName;
        }
        return new IdentAuthenticator(auth.in, auth.out, user);
    }

    public boolean checkRequest(ProxyMessage msg, Socket s) {
        if (msg.version == 5 || this.user == null) {
            return true;
        }
        if (msg.version != 4) {
            return false;
        }
        return this.user.equals(msg.user);
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.hosts.size(); ++i) {
            s = s + "Range:" + this.hosts.elementAt(i) + "\nUsers:" + this.userNames(i) + "\n";
        }
        return s;
    }

    private int getRangeIndex(InetAddress ip) {
        int index = 0;
        Enumeration<InetRange> e = this.hosts.elements();
        while (e.hasMoreElements()) {
            InetRange ir = e.nextElement();
            if (ir.contains(ip)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private String userNames(int i) {
        if (this.users.elementAt(i) == null) {
            return "Everybody is permitted.";
        }
        Enumeration<String> e = this.users.elementAt(i).keys();
        if (!e.hasMoreElements()) {
            return "";
        }
        String s = e.nextElement().toString();
        while (e.hasMoreElements()) {
            s = s + "; " + e.nextElement();
        }
        return s;
    }
}

