/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import socks.InetRange;
import socks.Proxy;
import socks.ProxyMessage;
import socks.Socks4Message;
import socks.SocksException;

public class Socks4Proxy
extends Proxy
implements Cloneable {
    String user;

    public Socks4Proxy(Proxy p, String proxyHost, int proxyPort, String user) throws UnknownHostException {
        super(p, proxyHost, proxyPort);
        this.user = new String(user);
        this.version = 4;
    }

    public Socks4Proxy(String proxyHost, int proxyPort, String user) throws UnknownHostException {
        this(null, proxyHost, proxyPort, user);
    }

    public Socks4Proxy(Proxy p, InetAddress proxyIP, int proxyPort, String user) {
        super(p, proxyIP, proxyPort);
        this.user = new String(user);
        this.version = 4;
    }

    public Socks4Proxy(InetAddress proxyIP, int proxyPort, String user) {
        this(null, proxyIP, proxyPort, user);
    }

    public Object clone() {
        Socks4Proxy newProxy = new Socks4Proxy(this.proxyIP, this.proxyPort, this.user);
        newProxy.directHosts = (InetRange)this.directHosts.clone();
        newProxy.chainProxy = this.chainProxy;
        return newProxy;
    }

    protected Proxy copy() {
        Socks4Proxy copy = new Socks4Proxy(this.proxyIP, this.proxyPort, this.user);
        copy.directHosts = this.directHosts;
        copy.chainProxy = this.chainProxy;
        return copy;
    }

    protected ProxyMessage formMessage(int cmd, InetAddress ip, int port) {
        switch (cmd) {
            case 1: {
                cmd = 1;
                break;
            }
            case 2: {
                cmd = 2;
                break;
            }
            default: {
                return null;
            }
        }
        return new Socks4Message(cmd, ip, port, this.user);
    }

    protected ProxyMessage formMessage(int cmd, String host, int port) throws UnknownHostException {
        return this.formMessage(cmd, InetAddress.getByName(host), port);
    }

    protected ProxyMessage formMessage(InputStream in) throws SocksException, IOException {
        return new Socks4Message(in, true);
    }
}

