/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.message;

import com.sshtools.logging.Log;
import com.sshtools.ssh.message.MessageHolder;
import com.sshtools.ssh.message.MessageObserver;
import com.sshtools.ssh.message.MessageStore;

public class ThreadSynchronizer {
    boolean isBlocking;
    Thread blockingThread = null;
    boolean verbose = Boolean.valueOf(System.getProperty("maverick.verbose", "false"));

    public ThreadSynchronizer(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestBlock(MessageStore store, MessageObserver observer, MessageHolder holder) throws InterruptedException {
        holder.msg = store.hasMessage(observer);
        if (holder.msg != null) {
            return false;
        }
        ThreadSynchronizer threadSynchronizer = this;
        synchronized (threadSynchronizer) {
            boolean canBlock;
            if (Log.isDebugEnabled() && this.verbose) {
                Log.debug(this, "requesting block");
            }
            boolean bl = canBlock = !this.isBlocking || this.isBlockOwner(Thread.currentThread());
            if (canBlock) {
                this.isBlocking = true;
                this.blockingThread = Thread.currentThread();
            } else {
                if (Log.isDebugEnabled() && this.verbose) {
                    Log.debug(this, "can't block so wait");
                    Log.debug(this, "isBlocking:" + this.isBlocking);
                    Log.debug(this, "blockowner name:id{" + this.blockingThread.getName() + "}");
                    Log.debug(this, "currentthread name:id{" + Thread.currentThread().getName() + "}");
                }
                this.wait(1000L);
            }
            return canBlock;
        }
    }

    public synchronized boolean isBlockOwner(Thread thread) {
        return this.blockingThread != null && this.blockingThread.equals(thread);
    }

    public synchronized void releaseWaiting() {
        this.notifyAll();
    }

    public synchronized void releaseBlock() {
        this.isBlocking = false;
        this.blockingThread = null;
        this.notifyAll();
    }
}

