/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.ssh.components.jce.Ssh2RsaPublicKey;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

public class SshX509RsaSha1PublicKey
extends Ssh2RsaPublicKey {
    public static final String X509V3_SIGN_RSA_SHA1 = "x509v3-sign-rsa-sha1";
    X509Certificate cert;

    public SshX509RsaSha1PublicKey() {
    }

    public SshX509RsaSha1PublicKey(X509Certificate cert) {
        super((RSAPublicKey)cert.getPublicKey());
        this.cert = cert;
    }

    public String getAlgorithm() {
        return X509V3_SIGN_RSA_SHA1;
    }

    public byte[] getEncoded() throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeString(this.getAlgorithm());
            baw.writeBinaryString(this.cert.getEncoded());
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
        catch (Throwable ex) {
            throw new SshException("Failed to encoded key data", 5, ex);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void init(byte[] blob, int start, int len) throws SshException {
        ByteArrayReader bar = new ByteArrayReader(blob, start, len);
        try {
            String header = bar.readString();
            if (!header.equals(X509V3_SIGN_RSA_SHA1)) {
                throw new SshException("The encoded key is not X509 RSA", 5);
            }
            byte[] encoded = bar.readBinaryString();
            ByteArrayInputStream is = new ByteArrayInputStream(encoded);
            CertificateFactory cf = JCEProvider.getProviderForAlgorithm("X.509") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", JCEProvider.getProviderForAlgorithm("X.509"));
            this.cert = (X509Certificate)cf.generateCertificate(is);
            if (!(this.cert.getPublicKey() instanceof RSAPublicKey)) {
                throw new SshException("Certificate public key is not an RSA public key!", 4);
            }
            this.pubKey = (RSAPublicKey)this.cert.getPublicKey();
        }
        catch (Throwable ex) {
            throw new SshException(ex.getMessage(), 16, ex);
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException header) {}
        }
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }
}

