/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.ssh.components.jce.Ssh2RsaPublicKey;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

public class SshX509RsaPublicKey
extends Ssh2RsaPublicKey {
    public static final String X509V3_SIGN_RSA = "x509v3-sign-rsa";
    X509Certificate cert;

    public SshX509RsaPublicKey() {
    }

    public SshX509RsaPublicKey(X509Certificate cert) {
        super((RSAPublicKey)cert.getPublicKey());
        this.cert = cert;
    }

    public String getAlgorithm() {
        return X509V3_SIGN_RSA;
    }

    public byte[] getEncoded() throws SshException {
        try {
            return this.cert.getEncoded();
        }
        catch (Throwable ex) {
            throw new SshException("Failed to encoded key data", 5, ex);
        }
    }

    public void init(byte[] blob, int start, int len) throws SshException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(blob, start, len);
            CertificateFactory cf = JCEProvider.getProviderForAlgorithm("X.509") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", JCEProvider.getProviderForAlgorithm("X.509"));
            this.cert = (X509Certificate)cf.generateCertificate(is);
            if (!(this.cert.getPublicKey() instanceof RSAPublicKey)) {
                throw new SshException("Certificate public key is not an RSA public key!", 4);
            }
            this.pubKey = (RSAPublicKey)this.cert.getPublicKey();
        }
        catch (Throwable ex) {
            throw new SshException(ex.getMessage(), 16, ex);
        }
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }
}

