/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshKeyFingerprint;
import com.sshtools.ssh.components.SshPublicKey;
import com.sshtools.ssh.components.SshRsaPublicKey;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

public class Ssh2RsaPublicKey
implements SshRsaPublicKey {
    RSAPublicKey pubKey;

    public Ssh2RsaPublicKey() {
    }

    public Ssh2RsaPublicKey(RSAPublicKey pubKey) {
        this.pubKey = pubKey;
    }

    public Ssh2RsaPublicKey(BigInteger modulus, BigInteger publicExponent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
        this.pubKey = (RSAPublicKey)keyFactory.generatePublic(spec);
    }

    public byte[] getEncoded() throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeString(this.getAlgorithm());
            baw.writeBigInteger(this.pubKey.getPublicExponent());
            baw.writeBigInteger(this.pubKey.getModulus());
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new SshException("Failed to encoded key data", 5, ex);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    public int getBitLength() {
        return this.pubKey.getModulus().bitLength();
    }

    public void init(byte[] blob, int start, int len) throws SshException {
        ByteArrayReader bar = new ByteArrayReader(blob, start, len);
        try {
            String header = bar.readString();
            if (!header.equals(this.getAlgorithm())) {
                throw new SshException("The encoded key is not RSA", 5);
            }
            BigInteger e = bar.readBigInteger();
            BigInteger n = bar.readBigInteger();
            RSAPublicKeySpec rsaKey = new RSAPublicKeySpec(n, e);
            try {
                KeyFactory kf = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
                this.pubKey = (RSAPublicKey)kf.generatePublic(rsaKey);
            }
            catch (Exception ex) {
                throw new SshException("Failed to obtain RSA key instance from JCE", 5, ex);
            }
        }
        catch (IOException ioe) {
            throw new SshException("Failed to read encoded key data", 5);
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }

    public boolean verifySignature(byte[] signature, byte[] data) throws SshException {
        ByteArrayReader bar = new ByteArrayReader(signature);
        try {
            if (signature.length != 128) {
                byte[] sig = bar.readBinaryString();
                String header = new String(sig);
                signature = bar.readBinaryString();
            }
            Signature s = JCEProvider.getProviderForAlgorithm("SHA1WithRSA") == null ? Signature.getInstance("SHA1WithRSA") : Signature.getInstance("SHA1WithRSA", JCEProvider.getProviderForAlgorithm("SHA1WithRSA"));
            s.initVerify(this.pubKey);
            s.update(data);
            boolean bl = s.verify(signature);
            return bl;
        }
        catch (Exception ex) {
            throw new SshException(16, (Throwable)ex);
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshRsaPublicKey) {
            try {
                return ((SshPublicKey)obj).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException ex) {
            return 0;
        }
    }

    public BigInteger doPublic(BigInteger input) throws SshException {
        try {
            Cipher cipher = JCEProvider.getProviderForAlgorithm("RSA") == null ? Cipher.getInstance("RSA") : Cipher.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            cipher.init(1, (Key)this.pubKey, JCEProvider.getSecureRandom());
            byte[] tmp = input.toByteArray();
            return new BigInteger(cipher.doFinal(tmp, tmp[0] == 0 ? 1 : 0, tmp[0] == 0 ? tmp.length - 1 : tmp.length));
        }
        catch (Throwable e) {
            if (e.getMessage().indexOf("RSA") > -1) {
                throw new SshException("JCE provider requires BouncyCastle provider for RSA/NONE/PKCS1Padding component. Add bcprov.jar to your classpath or configure an alternative provider for this algorithm", 5);
            }
            throw new SshException(e);
        }
    }

    public BigInteger getModulus() {
        return this.pubKey.getModulus();
    }

    public BigInteger getPublicExponent() {
        return this.pubKey.getPublicExponent();
    }

    public int getVersion() {
        return 2;
    }
}

