/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.ssh.components.jce.JCEProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.crypto.Cipher;

public class Ssh2RsaPrivateCrtKey
implements SshRsaPrivateCrtKey {
    protected RSAPrivateCrtKey prv;

    public Ssh2RsaPrivateCrtKey(RSAPrivateCrtKey prv) {
        this.prv = prv;
    }

    public Ssh2RsaPrivateCrtKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        this.prv = (RSAPrivateCrtKey)keyFactory.generatePrivate(spec);
    }

    public BigInteger doPrivate(BigInteger input) throws SshException {
        try {
            Cipher cipher = JCEProvider.getProviderForAlgorithm("RSA") == null ? Cipher.getInstance("RSA") : Cipher.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            cipher.init(2, (Key)this.prv, JCEProvider.getSecureRandom());
            return new BigInteger(cipher.doFinal(input.toByteArray()));
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    public BigInteger getCrtCoefficient() {
        return this.prv.getCrtCoefficient();
    }

    public BigInteger getPrimeExponentP() {
        return this.prv.getPrimeExponentP();
    }

    public BigInteger getPrimeExponentQ() {
        return this.prv.getPrimeExponentQ();
    }

    public BigInteger getPrimeP() {
        return this.prv.getPrimeP();
    }

    public BigInteger getPrimeQ() {
        return this.prv.getPrimeQ();
    }

    public BigInteger getPublicExponent() {
        return this.prv.getPublicExponent();
    }

    public BigInteger getModulus() {
        return this.prv.getModulus();
    }

    public BigInteger getPrivateExponent() {
        return this.prv.getPrivateExponent();
    }

    public byte[] sign(byte[] msg) throws IOException {
        try {
            Signature l_sig = JCEProvider.getProviderForAlgorithm("SHA1WithRSA") == null ? Signature.getInstance("SHA1WithRSA") : Signature.getInstance("SHA1WithRSA", JCEProvider.getProviderForAlgorithm("SHA1WithRSA"));
            l_sig.initSign(this.prv);
            l_sig.update(msg);
            return l_sig.sign();
        }
        catch (Exception e) {
            throw new IOException("Failed to sign data! " + e.getMessage());
        }
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }
}

