/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshKeyFingerprint;
import com.sshtools.ssh.components.SshPublicKey;
import com.sshtools.ssh.components.jce.ECUtils;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import com.sshtools.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;

public class Ssh2EcdsaSha2NistPublicKey
implements SshPublicKey {
    String name;
    String spec;
    String curve;
    protected ECPublicKey pub;

    public Ssh2EcdsaSha2NistPublicKey(ECPublicKey pub) throws IOException {
        this.pub = pub;
        String curve = pub.getParams().toString();
        if (curve.contains("prime256v1") || curve.contains("secp256r1")) {
            this.curve = "secp256r1";
            this.name = "ecdsa-sha2-nistp256";
            this.spec = "SHA256/ECDSA";
        } else if (curve.contains("secp384r1")) {
            this.curve = "secp384r1";
            this.name = "ecdsa-sha2-nistp384";
            this.spec = "SHA384/ECDSA";
        } else if (curve.contains("secp521r1")) {
            this.curve = "secp521r1";
            this.name = "ecdsa-sha2-nistp521";
            this.spec = "SHA512/ECDSA";
        } else {
            throw new IOException("Unsupported curve name " + curve);
        }
    }

    Ssh2EcdsaSha2NistPublicKey(String name, String spec, String curve) {
        this.name = name;
        this.spec = spec;
        this.curve = curve;
    }

    public void init(byte[] blob, int start, int len) throws SshException {
        ByteArrayReader buf = new ByteArrayReader(blob, start, len);
        try {
            String type = buf.readString();
            buf.readString();
            byte[] Q = buf.readBinaryString();
            ECParameterSpec ecspec = this.getCurveParams(this.curve);
            ECPoint p = ECUtils.fromByteArray(Q, ecspec.getCurve());
            KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("EC") == null ? KeyFactory.getInstance("EC") : KeyFactory.getInstance("EC", JCEProvider.getProviderForAlgorithm("EC"));
            this.pub = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(p, ecspec));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new SshException("Failed to decode public key blob", 5);
        }
        finally {
            try {
                buf.close();
            }
            catch (IOException type) {}
        }
    }

    public String getAlgorithm() {
        return this.name;
    }

    public int getBitLength() {
        return this.pub.getParams().getOrder().bitLength();
    }

    public byte[] getEncoded() throws SshException {
        ByteArrayWriter blob = new ByteArrayWriter();
        try {
            blob.writeString(this.name);
            blob.writeString(this.name.substring(this.name.lastIndexOf("-") + 1));
            blob.writeBinaryString(this.getPublicOctet());
            byte[] byArray = blob.toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            throw new SshException("Failed to encode public key", 5);
        }
        finally {
            try {
                blob.close();
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] getPublicOctet() {
        return ECUtils.toByteArray(this.pub.getW(), this.pub.getParams().getCurve());
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    public boolean verifySignature(byte[] signature, byte[] data) throws SshException {
        ByteArrayReader bar = new ByteArrayReader(signature);
        try {
            int len = (int)bar.readInt();
            if (bar.available() > len) {
                byte[] sig = new byte[len];
                bar.read(sig);
                String header = new String(sig);
                if (!header.equals(this.name)) {
                    throw new SshException("The encoded signature is not ECDSA", 5);
                }
                signature = bar.readBinaryString();
            }
            bar.close();
            bar = new ByteArrayReader(signature);
            BigInteger r = bar.readBigInteger();
            BigInteger s = bar.readBigInteger();
            SimpleASNWriter asn = new SimpleASNWriter();
            asn.writeByte(2);
            asn.writeData(r.toByteArray());
            asn.writeByte(2);
            asn.writeData(s.toByteArray());
            SimpleASNWriter asnEncoded = new SimpleASNWriter();
            asnEncoded.writeByte(48);
            asnEncoded.writeData(asn.toByteArray());
            byte[] encoded = asnEncoded.toByteArray();
            Signature sig = JCEProvider.getProviderForAlgorithm(this.spec) == null ? Signature.getInstance(this.spec) : Signature.getInstance(this.spec, JCEProvider.getProviderForAlgorithm(this.spec));
            sig.initVerify(this.pub);
            sig.update(data);
            boolean bl = sig.verify(encoded);
            return bl;
        }
        catch (Exception ex) {
            throw new SshException(16, (Throwable)ex);
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException iOException) {}
        }
    }

    public ECParameterSpec getCurveParams(String curve) {
        try {
            KeyPairGenerator gen = JCEProvider.getProviderForAlgorithm("EC") == null ? KeyPairGenerator.getInstance("EC") : KeyPairGenerator.getInstance("EC", JCEProvider.getProviderForAlgorithm("EC"));
            gen.initialize(new ECGenParameterSpec(curve), JCEProvider.getSecureRandom());
            KeyPair tmp = gen.generateKeyPair();
            return ((ECPublicKey)tmp.getPublic()).getParams();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public PublicKey getJCEPublicKey() {
        return this.pub;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pub == null ? 0 : this.pub.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ssh2EcdsaSha2NistPublicKey other = (Ssh2EcdsaSha2NistPublicKey)obj;
        return !(this.pub == null ? other.pub != null : !this.pub.equals(other.pub));
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        ECGenParameterSpec gps = new ECGenParameterSpec("secp256r1");
        kpg.initialize(gps);
        KeyPair apair = kpg.generateKeyPair();
        ECPublicKey apub = (ECPublicKey)apair.getPublic();
        ECParameterSpec aspec = apub.getParams();
        ECPoint apoint = apub.getW();
        BigInteger x = apoint.getAffineX();
        BigInteger y = apoint.getAffineY();
        ECPoint bpoint = new ECPoint(x, y);
        ECPublicKeySpec bpubs = new ECPublicKeySpec(bpoint, aspec);
        KeyFactory kfa = KeyFactory.getInstance("EC");
        ECPublicKey bpub = (ECPublicKey)kfa.generatePublic(bpubs);
        new Ssh2EcdsaSha2NistPublicKey(bpub);
    }
}

