/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.logging.LoggerFactory;
import com.sshtools.logging.LoggerLevel;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.Digest;
import com.sshtools.ssh.components.SshKeyExchange;
import com.sshtools.ssh.components.SshKeyExchangeClient;
import com.sshtools.ssh.components.jce.ECUtils;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import javax.crypto.KeyAgreement;

public class DiffieHellmanEcdh
extends SshKeyExchangeClient
implements SshKeyExchange {
    public static final int SSH_MSG_KEX_ECDH_INIT = 30;
    public static final int SSH_MSG_KEX_ECDH_REPLY = 31;
    String name;
    String curve;
    byte[] Q_S;
    byte[] Q_C;
    String clientId;
    String serverId;
    byte[] clientKexInit;
    byte[] serverKexInit;

    protected DiffieHellmanEcdh(String name, String curve, String hashAlgorithm) {
        super(hashAlgorithm);
        this.name = name;
        this.curve = curve;
    }

    public String getAlgorithm() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit) throws SshException {
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDH");
            ECGenParameterSpec namedSpec = new ECGenParameterSpec(this.curve);
            keyGen.initialize(namedSpec, new SecureRandom());
            KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
            KeyPair keyPair = keyGen.generateKeyPair();
            keyAgreement.init(keyPair.getPrivate());
            ECPublicKey ec = (ECPublicKey)keyPair.getPublic();
            ByteArrayWriter msg = new ByteArrayWriter();
            this.Q_C = ECUtils.toByteArray(ec.getW(), ec.getParams().getCurve());
            try {
                msg.write(30);
                msg.writeBinaryString(this.Q_C);
                if (LoggerFactory.getInstance().isLevelEnabled(LoggerLevel.DEBUG)) {
                    LoggerFactory.getInstance().log(LoggerLevel.DEBUG, this, "Sending SSH_MSG_KEX_ECDH_INIT");
                }
                this.transport.sendMessage(msg.toByteArray(), true);
            }
            finally {
                msg.close();
            }
            byte[] resp = this.transport.nextMessage();
            if (resp[0] != 31) {
                throw new SshException("Expected SSH_MSG_KEX_ECDH_REPLY but got message id " + resp[0], 9);
            }
            ByteArrayReader reply = new ByteArrayReader(resp, 1, resp.length - 1);
            try {
                this.hostKey = reply.readBinaryString();
                this.Q_S = reply.readBinaryString();
                this.signature = reply.readBinaryString();
                keyAgreement.doPhase(ECUtils.decodeKey(this.Q_S, this.curve), true);
                byte[] tmp = keyAgreement.generateSecret();
                if ((tmp[0] & 0x80) == 128) {
                    byte[] tmp2 = new byte[tmp.length + 1];
                    System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
                    tmp = tmp2;
                }
                this.secret = new BigInteger(tmp);
            }
            finally {
                reply.close();
            }
            this.calculateExchangeHash();
        }
        catch (Exception e) {
            throw new SshException("Failed to process key exchange", 5, e);
        }
    }

    public boolean isKeyExchangeMessage(int messageid) {
        switch (messageid) {
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putInt(this.Q_C.length);
        hash.putBytes(this.Q_C);
        hash.putInt(this.Q_S.length);
        hash.putBytes(this.Q_S);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }
}

