/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components;

import com.sshtools.logging.Log;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.ComponentFactory;
import com.sshtools.ssh.components.NoneCipher;
import com.sshtools.ssh.components.NoneHmac;
import com.sshtools.ssh.components.SshCipher;
import com.sshtools.ssh.components.SshDsaPrivateKey;
import com.sshtools.ssh.components.SshDsaPublicKey;
import com.sshtools.ssh.components.SshHmac;
import com.sshtools.ssh.components.SshKeyExchange;
import com.sshtools.ssh.components.SshKeyPair;
import com.sshtools.ssh.components.SshPublicKey;
import com.sshtools.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.ssh.components.SshRsaPrivateKey;
import com.sshtools.ssh.components.SshRsaPublicKey;
import com.sshtools.ssh.components.SshSecureRandomGenerator;
import com.sshtools.ssh.components.jce.JCEComponentManager;
import java.math.BigInteger;

public abstract class ComponentManager {
    private static boolean PerContextAlgorithmPreferences = false;
    private static boolean enableNoneCipher = false;
    private static boolean enableNoneMac = false;
    private static ComponentManager instance;
    ComponentFactory ssh2ciphersSC;
    ComponentFactory ssh2ciphersCS;
    ComponentFactory hmacsCS;
    ComponentFactory hmacsSC;
    ComponentFactory keyexchange;
    ComponentFactory publickeys;
    ComponentFactory digests;
    static Object lock;

    public static boolean isEnableNoneCipher() {
        return enableNoneCipher;
    }

    public static void setEnableNoneCipher(boolean enableNoneCipher) {
        ComponentManager.enableNoneCipher = enableNoneCipher;
    }

    public static boolean isEnableNoneMac() {
        return enableNoneMac;
    }

    public static void setEnableNoneMac(boolean enableNoneCipher) {
        enableNoneMac = enableNoneCipher;
    }

    public static void setPerContextAlgorithmPreferences(boolean enable) {
        PerContextAlgorithmPreferences = enable;
    }

    public static boolean getPerContextAlgorithmPreferences() {
        return PerContextAlgorithmPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentManager getInstance() throws SshException {
        Class<ComponentManager> clazz = ComponentManager.class;
        synchronized (ComponentManager.class) {
            if (instance == null) {
                instance = new JCEComponentManager();
                instance.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void init() throws SshException {
        Log.info(this, "Initializing SSH2 server->client ciphers");
        this.ssh2ciphersSC = new ComponentFactory(SshCipher.class);
        this.initializeSsh2CipherFactory(this.ssh2ciphersSC);
        if (enableNoneCipher) {
            this.ssh2ciphersSC.add("none", NoneCipher.class);
            Log.info(this, "   none will be a supported cipher");
        }
        Log.info(this, "Initializing SSH2 client->server ciphers");
        this.ssh2ciphersCS = new ComponentFactory(SshCipher.class);
        this.initializeSsh2CipherFactory(this.ssh2ciphersCS);
        if (enableNoneCipher) {
            this.ssh2ciphersCS.add("none", NoneCipher.class);
            Log.info(this, "   none will be a supported cipher");
        }
        Log.info(this, "Initializing SSH2 server->client HMACs");
        this.hmacsSC = new ComponentFactory(SshHmac.class);
        this.initializeHmacFactory(this.hmacsSC);
        if (enableNoneMac) {
            this.hmacsSC.add("none", NoneHmac.class);
            Log.info(this, "   none will be a supported hmac");
        }
        Log.info(this, "Initializing SSH2 client->server HMACs");
        this.hmacsCS = new ComponentFactory(SshHmac.class);
        this.initializeHmacFactory(this.hmacsCS);
        if (enableNoneMac) {
            this.hmacsCS.add("none", NoneHmac.class);
            Log.info(this, "   none will be a supported hmac");
        }
        Log.info(this, "Initializing public keys");
        this.publickeys = new ComponentFactory(SshPublicKey.class);
        this.initializePublicKeyFactory(this.publickeys);
        Log.info(this, "Initializing digests");
        this.digests = new ComponentFactory(SshPublicKey.class);
        this.initializeDigestFactory(this.digests);
        Log.info(this, "Initializing SSH2 key exchanges");
        this.keyexchange = new ComponentFactory(SshKeyExchange.class);
        this.initializeKeyExchangeFactory(this.keyexchange);
        Log.info(this, "Initializing Secure Random Number Generator");
        this.getRND().nextInt();
    }

    protected abstract void initializeSsh2CipherFactory(ComponentFactory var1);

    protected abstract void initializeHmacFactory(ComponentFactory var1);

    protected abstract void initializePublicKeyFactory(ComponentFactory var1);

    protected abstract void initializeKeyExchangeFactory(ComponentFactory var1);

    protected abstract void initializeDigestFactory(ComponentFactory var1);

    public static void setInstance(ComponentManager instance) {
        ComponentManager.instance = instance;
    }

    public ComponentFactory supportedSsh2CiphersSC() {
        if (PerContextAlgorithmPreferences) {
            return (ComponentFactory)this.ssh2ciphersSC.clone();
        }
        return this.ssh2ciphersSC;
    }

    public ComponentFactory supportedSsh2CiphersCS() {
        if (PerContextAlgorithmPreferences) {
            return (ComponentFactory)this.ssh2ciphersCS.clone();
        }
        return this.ssh2ciphersCS;
    }

    public ComponentFactory supportedHMacsSC() {
        if (PerContextAlgorithmPreferences) {
            return (ComponentFactory)this.hmacsSC.clone();
        }
        return this.hmacsSC;
    }

    public ComponentFactory supportedHMacsCS() {
        if (PerContextAlgorithmPreferences) {
            return (ComponentFactory)this.hmacsCS.clone();
        }
        return this.hmacsCS;
    }

    public ComponentFactory supportedKeyExchanges() {
        if (PerContextAlgorithmPreferences) {
            return (ComponentFactory)this.keyexchange.clone();
        }
        return this.keyexchange;
    }

    public ComponentFactory supportedPublicKeys() {
        if (PerContextAlgorithmPreferences) {
            return (ComponentFactory)this.publickeys.clone();
        }
        return this.publickeys;
    }

    public ComponentFactory supportedDigests() {
        if (PerContextAlgorithmPreferences) {
            return (ComponentFactory)this.digests.clone();
        }
        return this.digests;
    }

    public abstract SshKeyPair generateRsaKeyPair(int var1) throws SshException;

    public abstract SshRsaPublicKey createRsaPublicKey(BigInteger var1, BigInteger var2) throws SshException;

    public abstract SshRsaPublicKey createSsh2RsaPublicKey() throws SshException;

    public abstract SshRsaPrivateKey createRsaPrivateKey(BigInteger var1, BigInteger var2) throws SshException;

    public abstract SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6) throws SshException;

    public abstract SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6, BigInteger var7, BigInteger var8) throws SshException;

    public abstract SshKeyPair generateDsaKeyPair(int var1) throws SshException;

    public abstract SshDsaPublicKey createDsaPublicKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4) throws SshException;

    public abstract SshDsaPublicKey createDsaPublicKey();

    public abstract SshDsaPrivateKey createDsaPrivateKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5) throws SshException;

    public abstract SshSecureRandomGenerator getRND() throws SshException;

    static {
        lock = new Object();
    }
}

