/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sftp;

import com.sshtools.sftp.ACL;
import com.sshtools.sftp.SftpSubsystemChannel;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import com.sshtools.util.UnsignedInteger32;
import com.sshtools.util.UnsignedInteger64;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SftpFileAttributes {
    static final int SSH_FILEXFER_ATTR_SIZE = 1;
    static final long SSH_FILEXFER_ATTR_UIDGID = 2L;
    static final long SSH_FILEXFER_ATTR_PERMISSIONS = 4L;
    static final long SSH_FILEXFER_ATTR_ACCESSTIME = 8L;
    static final long SSH_FILEXFER_ATTR_CREATETIME = 16L;
    static final long SSH_FILEXFER_ATTR_MODIFYTIME = 32L;
    static final long SSH_FILEXFER_ATTR_ACL = 64L;
    static final long SSH_FILEXFER_ATTR_OWNERGROUP = 128L;
    static final long SSH_FILEXFER_ATTR_SUBSECOND_TIMES = 256L;
    static final long SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    private Vector<ACL> acls = new Vector();
    private Hashtable<String, byte[]> extendedAttributes = new Hashtable();
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    int version = 3;
    long flags = 0L;
    int type;
    UnsignedInteger64 size = null;
    String uid = null;
    String gid = null;
    UnsignedInteger32 permissions = null;
    UnsignedInteger64 atime = null;
    UnsignedInteger32 atime_nano = null;
    UnsignedInteger64 createtime = null;
    UnsignedInteger32 createtime_nano = null;
    UnsignedInteger64 mtime = null;
    UnsignedInteger32 mtime_nano = null;
    String username;
    String group;
    char[] types = new char[]{'p', 'c', 'd', 'b', '-', 'l', 's'};
    SftpSubsystemChannel sftp;

    public SftpFileAttributes(SftpSubsystemChannel sftp, int type) {
        this.sftp = sftp;
        this.version = sftp.getVersion();
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public SftpFileAttributes(SftpSubsystemChannel sftp, ByteArrayReader bar) throws IOException {
        int length;
        this.sftp = sftp;
        this.version = sftp.getVersion();
        if (bar.available() >= 4) {
            this.flags = bar.readInt();
        }
        if (this.version > 3 && bar.available() > 0) {
            this.type = bar.read();
        }
        if (this.isFlagSet(1L) && bar.available() >= 8) {
            byte[] raw = new byte[8];
            bar.read(raw);
            this.size = new UnsignedInteger64(raw);
        }
        if (this.version <= 3 && this.isFlagSet(2L) && bar.available() >= 8) {
            this.uid = String.valueOf(bar.readInt());
            this.gid = String.valueOf(bar.readInt());
        } else if (this.version > 3 && this.isFlagSet(128L) && bar.available() >= 8) {
            this.uid = bar.readString(sftp.getCharsetEncoding());
            this.gid = bar.readString(sftp.getCharsetEncoding());
        }
        if (this.isFlagSet(4L) && bar.available() >= 4) {
            this.permissions = new UnsignedInteger32(bar.readInt());
        }
        if (this.version <= 3 && this.isFlagSet(8L) && bar.available() >= 8) {
            this.atime = new UnsignedInteger64(bar.readInt());
            this.mtime = new UnsignedInteger64(bar.readInt());
        } else if (this.version > 3 && bar.available() > 0) {
            if (this.isFlagSet(8L) && bar.available() >= 8) {
                this.atime = bar.readUINT64();
            }
            if (this.isFlagSet(256L) && bar.available() >= 4) {
                this.atime_nano = bar.readUINT32();
            }
        }
        if (this.version > 3 && bar.available() > 0) {
            if (this.isFlagSet(16L) && bar.available() >= 8) {
                this.createtime = bar.readUINT64();
            }
            if (this.isFlagSet(256L) && bar.available() >= 4) {
                this.createtime_nano = bar.readUINT32();
            }
        }
        if (this.version > 3 && bar.available() > 0) {
            if (this.isFlagSet(32L) && bar.available() >= 8) {
                this.mtime = bar.readUINT64();
            }
            if (this.isFlagSet(256L) && bar.available() >= 4) {
                this.mtime_nano = bar.readUINT32();
            }
        }
        if (this.version > 3 && this.isFlagSet(64L) && bar.available() >= 4 && (length = (int)bar.readInt()) > 0 && bar.available() >= length) {
            int count = (int)bar.readInt();
            for (int i = 0; i < count; ++i) {
                this.acls.addElement(new ACL((int)bar.readInt(), (int)bar.readInt(), (int)bar.readInt(), bar.readString()));
            }
        }
        if (this.version >= 3 && this.isFlagSet(Integer.MIN_VALUE) && bar.available() >= 4) {
            int count = (int)bar.readInt();
            for (int i = 0; i < count; ++i) {
                if (bar.available() < 8) continue;
                this.extendedAttributes.put(bar.readString(), bar.readBinaryString());
            }
        }
    }

    public String getUID() {
        if (this.username != null) {
            return this.username;
        }
        if (this.uid != null) {
            return this.uid;
        }
        return "";
    }

    public void setUID(String uid) {
        this.flags = this.version > 3 ? (this.flags |= 0x80L) : (this.flags |= 2L);
        this.uid = uid;
    }

    public void setGID(String gid) {
        this.flags = this.version > 3 ? (this.flags |= 0x80L) : (this.flags |= 2L);
        this.gid = gid;
    }

    public String getGID() {
        if (this.group != null) {
            return this.group;
        }
        if (this.gid != null) {
            return this.gid;
        }
        return "";
    }

    public boolean hasUID() {
        return this.uid != null;
    }

    public boolean hasGID() {
        return this.gid != null;
    }

    public void setSize(UnsignedInteger64 size) {
        this.size = size;
        this.flags = size != null ? (this.flags |= 1L) : (this.flags ^= 1L);
    }

    public UnsignedInteger64 getSize() {
        if (this.size != null) {
            return this.size;
        }
        return new UnsignedInteger64("0");
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public void setPermissions(UnsignedInteger32 permissions) {
        this.permissions = permissions;
        this.flags = permissions != null ? (this.flags |= 4L) : (this.flags ^= 4L);
    }

    public void setPermissionsFromMaskString(String mask) {
        if (mask.length() != 4) {
            throw new IllegalArgumentException("Mask length must be 4");
        }
        try {
            this.setPermissions(new UnsignedInteger32(String.valueOf(Integer.parseInt(mask, 8))));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Mask must be 4 digit octal number.");
        }
    }

    public void setPermissionsFromUmaskString(String umask) {
        if (umask.length() != 4) {
            throw new IllegalArgumentException("umask length must be 4");
        }
        try {
            this.setPermissions(new UnsignedInteger32(String.valueOf(Integer.parseInt(umask, 8) ^ 0x1FF)));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("umask must be 4 digit octal number");
        }
    }

    public void setPermissions(String newPermissions) {
        int len;
        int cp = 0;
        if (this.permissions != null) {
            cp |= (this.permissions.longValue() & 0xF000L) == 61440L ? 61440 : 0;
            cp |= (this.permissions.longValue() & 0xC000L) == 49152L ? 49152 : 0;
            cp |= (this.permissions.longValue() & 0xA000L) == 40960L ? 40960 : 0;
            cp |= (this.permissions.longValue() & 0x8000L) == 32768L ? 32768 : 0;
            cp |= (this.permissions.longValue() & 0x6000L) == 24576L ? 24576 : 0;
            cp |= (this.permissions.longValue() & 0x4000L) == 16384L ? 16384 : 0;
            cp |= (this.permissions.longValue() & 0x2000L) == 8192L ? 8192 : 0;
            cp |= (this.permissions.longValue() & 0x1000L) == 4096L ? 4096 : 0;
            cp |= (this.permissions.longValue() & 0x800L) == 2048L ? 2048 : 0;
            cp |= (this.permissions.longValue() & 0x400L) == 1024L ? 1024 : 0;
        }
        if ((len = newPermissions.length()) >= 1) {
            cp |= newPermissions.charAt(0) == 'r' ? 256 : 0;
        }
        if (len >= 2) {
            cp |= newPermissions.charAt(1) == 'w' ? 128 : 0;
        }
        if (len >= 3) {
            cp |= newPermissions.charAt(2) == 'x' ? 64 : 0;
        }
        if (len >= 4) {
            cp |= newPermissions.charAt(3) == 'r' ? 32 : 0;
        }
        if (len >= 5) {
            cp |= newPermissions.charAt(4) == 'w' ? 16 : 0;
        }
        if (len >= 6) {
            cp |= newPermissions.charAt(5) == 'x' ? 8 : 0;
        }
        if (len >= 7) {
            cp |= newPermissions.charAt(6) == 'r' ? 4 : 0;
        }
        if (len >= 8) {
            cp |= newPermissions.charAt(7) == 'w' ? 2 : 0;
        }
        if (len >= 9) {
            cp |= newPermissions.charAt(8) == 'x' ? 1 : 0;
        }
        this.setPermissions(new UnsignedInteger32(cp));
    }

    public UnsignedInteger32 getPermissions() {
        if (this.permissions != null) {
            return this.permissions;
        }
        return new UnsignedInteger32(0L);
    }

    public void setTimes(UnsignedInteger64 atime, UnsignedInteger64 mtime) {
        this.atime = atime;
        this.mtime = mtime;
        this.flags = atime != null ? (this.flags |= 8L) : (this.flags ^= 8L);
    }

    public UnsignedInteger64 getAccessedTime() {
        return this.atime;
    }

    public UnsignedInteger64 getModifiedTime() {
        if (this.mtime != null) {
            return this.mtime;
        }
        return new UnsignedInteger64(0L);
    }

    public Date getModifiedDateTime() {
        long time = 0L;
        if (this.mtime != null) {
            time = this.mtime.longValue() * 1000L;
        }
        if (this.mtime_nano != null) {
            time += this.mtime_nano.longValue() / 1000000L;
        }
        return new Date(time);
    }

    public Date getCreationDateTime() {
        long time = 0L;
        if (this.createtime != null) {
            time = this.createtime.longValue() * 1000L;
        }
        if (this.createtime_nano != null) {
            time += this.createtime_nano.longValue() / 1000000L;
        }
        return new Date(time);
    }

    public Date getAccessedDateTime() {
        long time = 0L;
        if (this.atime != null) {
            time = this.atime.longValue() * 1000L;
        }
        if (this.atime != null) {
            time += this.atime_nano.longValue() / 1000000L;
        }
        return new Date(time);
    }

    public UnsignedInteger64 getCreationTime() {
        if (this.createtime != null) {
            return this.createtime;
        }
        return new UnsignedInteger64(0L);
    }

    public boolean isFlagSet(long flag) {
        return (this.flags & (flag & 0xFFFFFFFFL)) == (flag & 0xFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeInt(this.flags);
            if (this.version > 3) {
                baw.write(this.type);
            }
            if (this.isFlagSet(1L)) {
                baw.write(this.size.toByteArray());
            }
            if (this.version <= 3 && this.isFlagSet(2L)) {
                if (this.uid != null) {
                    try {
                        baw.writeInt(Long.parseLong(this.uid));
                    }
                    catch (NumberFormatException ex) {
                        baw.writeInt(0);
                    }
                } else {
                    baw.writeInt(0);
                }
                if (this.gid != null) {
                    try {
                        baw.writeInt(Long.parseLong(this.gid));
                    }
                    catch (NumberFormatException ex) {
                        baw.writeInt(0);
                    }
                } else {
                    baw.writeInt(0);
                }
            } else if (this.version > 3 && this.isFlagSet(128L)) {
                if (this.uid != null) {
                    baw.writeString(this.uid, this.sftp.getCharsetEncoding());
                } else {
                    baw.writeString("");
                }
                if (this.gid != null) {
                    baw.writeString(this.gid, this.sftp.getCharsetEncoding());
                } else {
                    baw.writeString("");
                }
            }
            if (this.isFlagSet(4L)) {
                baw.writeInt(this.permissions.longValue());
            }
            if (this.version <= 3 && this.isFlagSet(8L)) {
                baw.writeInt(this.atime.longValue());
                baw.writeInt(this.mtime.longValue());
            } else if (this.version > 3) {
                if (this.isFlagSet(8L)) {
                    baw.writeUINT64(this.atime);
                }
                if (this.isFlagSet(256L)) {
                    baw.writeUINT32(this.atime_nano);
                }
                if (this.isFlagSet(16L)) {
                    baw.writeUINT64(this.createtime);
                }
                if (this.isFlagSet(256L)) {
                    baw.writeUINT32(this.createtime_nano);
                }
                if (this.isFlagSet(32L)) {
                    baw.writeUINT64(this.mtime);
                }
                if (this.isFlagSet(256L)) {
                    baw.writeUINT32(this.mtime_nano);
                }
            }
            if (this.isFlagSet(64L)) {
                ByteArrayWriter tmp = new ByteArrayWriter();
                try {
                    Enumeration<ACL> e = this.acls.elements();
                    tmp.writeInt(this.acls.size());
                    while (e.hasMoreElements()) {
                        ACL acl = e.nextElement();
                        tmp.writeInt(acl.getType());
                        tmp.writeInt(acl.getFlags());
                        tmp.writeInt(acl.getMask());
                        tmp.writeString(acl.getWho());
                    }
                    baw.writeBinaryString(tmp.toByteArray());
                }
                finally {
                    tmp.close();
                }
            }
            if (this.isFlagSet(Integer.MIN_VALUE)) {
                baw.writeInt(this.extendedAttributes.size());
                Enumeration<String> e = this.extendedAttributes.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    baw.writeString(key);
                    baw.writeBinaryString(this.extendedAttributes.get(key));
                }
            }
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    private int octal(int v, int r) {
        return (((v >>>= r) & 4) != 0 ? 4 : 0) + ((v & 2) != 0 ? 2 : 0) + ((v & 1) != 0 ? 1 : 0);
    }

    private String rwxString(int v, int r) {
        String rwx = (((v >>>= r) & 4) != 0 ? "r" : "-") + ((v & 2) != 0 ? "w" : "-");
        rwx = r == 6 && (this.permissions.longValue() & 0x800L) == 2048L || r == 3 && (this.permissions.longValue() & 0x400L) == 1024L ? rwx + ((v & 1) != 0 ? "s" : "S") : rwx + ((v & 1) != 0 ? "x" : "-");
        return rwx;
    }

    public String getPermissionsString() {
        if (this.permissions != null) {
            boolean has_ifmt;
            StringBuffer str = new StringBuffer();
            boolean bl = has_ifmt = ((int)this.permissions.longValue() & 0xF000) > 0;
            if (has_ifmt) {
                str.append(this.types[(int)(this.permissions.longValue() & 0xF000L) >>> 13]);
            } else {
                str.append('-');
            }
            str.append(this.rwxString((int)this.permissions.longValue(), 6));
            str.append(this.rwxString((int)this.permissions.longValue(), 3));
            str.append(this.rwxString((int)this.permissions.longValue(), 0));
            return str.toString();
        }
        return "";
    }

    public String getMaskString() {
        StringBuffer buf = new StringBuffer();
        if (this.permissions != null) {
            int i = (int)this.permissions.longValue();
            buf.append('0');
            buf.append(this.octal(i, 6));
            buf.append(this.octal(i, 3));
            buf.append(this.octal(i, 0));
        } else {
            buf.append("----");
        }
        return buf.toString();
    }

    public boolean isDirectory() {
        if (this.sftp.getVersion() > 3) {
            return this.type == 2;
        }
        return this.permissions != null && (this.permissions.longValue() & 0x4000L) == 16384L;
    }

    public boolean isFile() {
        if (this.sftp.getVersion() > 3) {
            return this.type == 1;
        }
        return this.permissions != null && (this.permissions.longValue() & 0x8000L) == 32768L;
    }

    public boolean isLink() {
        if (this.sftp.getVersion() > 3) {
            return this.type == 3;
        }
        return this.permissions != null && (this.permissions.longValue() & 0xA000L) == 40960L;
    }

    public boolean isFifo() {
        return this.permissions != null && (this.permissions.longValue() & 0x1000L) == 4096L;
    }

    public boolean isBlock() {
        return this.permissions != null && (this.permissions.longValue() & 0x6000L) == 24576L;
    }

    public boolean isCharacter() {
        return this.permissions != null && (this.permissions.longValue() & 0x2000L) == 8192L;
    }

    public boolean isSocket() {
        return this.permissions != null && (this.permissions.longValue() & 0xC000L) == 49152L;
    }

    void setUsername(String username) {
        this.username = username;
    }

    void setGroup(String group) {
        this.group = group;
    }
}

