/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.list;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.tag.LabelTagsUpdate;
import at.mrdevelopment.esl.type.wrapper.element.ESLLabel;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LabelList")
@XmlRootElement(name="LabelList")
public class ESLLabelList {
    @XmlElement(name="Label", required=true)
    public List<ESLLabel> List;

    public static ESLLabelList newExample() {
        ESLLabelList list = new ESLLabelList();
        list.List = new ArrayList<ESLLabel>();
        list.List.add(new ESLLabel("B1001C4A"));
        list.List.add(new ESLLabel("B1001C4B"));
        list.List.add(new ESLLabel("B1001C4C"));
        list.List.add(new ESLLabel("C10009B4"));
        return list;
    }

    public List<LabelId> toLabelIds() throws SerializeException {
        ArrayList<LabelId> list = new ArrayList<LabelId>(this.List.size());
        for (ESLLabel label : this.List) {
            list.add(label.toLabelId());
        }
        return list;
    }

    public List<LabelRegistration> toLabelRegistrations() throws SerializeException {
        ArrayList<LabelRegistration> list = new ArrayList<LabelRegistration>(this.List.size());
        for (ESLLabel label : this.List) {
            list.add(label.toLabelRegistration());
        }
        return list;
    }

    public Collection<LabelTagsUpdate> toLabelTagsUpdate(LabelTagsUpdate.Operation operation) throws SerializeException {
        ArrayList<LabelTagsUpdate> list = new ArrayList<LabelTagsUpdate>(this.List.size());
        for (ESLLabel label : this.List) {
            list.add(label.toTagsUpdate(operation));
        }
        return list;
    }
}

