/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLUserPagedResult;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.xml.SerializeException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="User")
@XmlRootElement(name="User")
public class ESLUser {
    @XmlAttribute
    public String username;
    @XmlAttribute
    public String firstName;
    @XmlAttribute
    public String lastName;
    @XmlAttribute
    public String mailAddress;
    @XmlAttribute
    public Role role;
    @XmlAttribute
    public String passwordHash;
    @XmlAttribute
    public Boolean apiAccess;
    @XmlAttribute
    public String apiToken;

    public static ESLUser wrap(User user) throws MappingException {
        return ESLWrapper.wrap(user, User.class, ESLUser.class);
    }

    public static ESLUserPagedResult wrap(QueryResult<User> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, User.class, ESLUser.class, ESLUserPagedResult.class);
    }

    public static ESLUser fromUser(User user) {
        ESLUser wrapper = new ESLUser();
        wrapper.username = user.getUsername();
        wrapper.firstName = user.getFirstName();
        wrapper.lastName = user.getLastName();
        wrapper.apiAccess = user.getApiAccess();
        wrapper.apiToken = user.getApiToken();
        wrapper.mailAddress = user.getMailAddress();
        wrapper.passwordHash = user.getPasswordHash();
        wrapper.role = user.getRole();
        return wrapper;
    }

    public static ESLUser newExample() {
        ESLUser example = new ESLUser();
        example.username = "admin";
        return example;
    }

    public User toUser() throws SerializeException {
        return new User(this.username, this.firstName, this.lastName, this.mailAddress, this.role, this.passwordHash, this.apiAccess, this.apiToken);
    }
}

