/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLUpdateStatusPagedResult;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="UpdateStatus")
@XmlRootElement(name="UpdateStatus")
public class ESLUpdateStatus {
    @XmlAttribute(required=true)
    public UUID id;
    @XmlElement(required=true)
    public String LabelId;
    @XmlElement(required=true)
    public TaskType TaskType;
    public Integer Page;
    @XmlElement(required=true)
    public TaskPriority TaskPriority;
    public Long ExternalId;
    @XmlElement(required=true)
    public long TransactionId;
    @XmlElement(required=true)
    public Status Status;
    public Integer ErrorCode;
    public String ErrorDescription;
    public Integer AccessPointId;
    public PowerStatus PowerStatus;
    public Integer Rssi;
    public Integer Lqi;
    public Integer TransmissionTime;
    @XmlElement(required=true)
    public int RetriesLeft;
    public Date LastChangedAt;
    public Date CreatedAt;
    @XmlAttribute(required=true)
    public boolean finished;
    public Date RetriesValidUntil;

    public static ESLUpdateStatus wrap(UpdateStatus updateStatus) throws MappingException {
        return ESLWrapper.wrap(updateStatus, UpdateStatus.class, ESLUpdateStatus.class);
    }

    public static ESLUpdateStatusPagedResult wrap(QueryResult<UpdateStatus> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, UpdateStatus.class, ESLUpdateStatus.class, ESLUpdateStatusPagedResult.class);
    }

    public static ESLUpdateStatus fromUpdateStatus(UpdateStatus updateStatus) {
        TaskRecord taskRecord = updateStatus.getTaskRecord();
        ESLUpdateStatus wrapper = new ESLUpdateStatus();
        wrapper.id = updateStatus.getTaskId();
        wrapper.LabelId = taskRecord.getLabelIdString();
        wrapper.TaskType = taskRecord.getTaskType();
        wrapper.Page = taskRecord.getPage();
        wrapper.TaskPriority = taskRecord.getPriority();
        wrapper.ExternalId = taskRecord.getExternalId() == 0L ? null : taskRecord.getExternalId();
        wrapper.TransactionId = taskRecord.getTransactionId() != null ? taskRecord.getTransactionId() : 0L;
        wrapper.Status = updateStatus.getStatus();
        wrapper.ErrorCode = updateStatus.getErrorCode();
        wrapper.ErrorDescription = updateStatus.getUpdateError() != null ? updateStatus.getUpdateError().getDescription() : null;
        wrapper.AccessPointId = updateStatus.getAccessPointId();
        wrapper.PowerStatus = updateStatus.getPowerStatus();
        wrapper.Rssi = updateStatus.getRssi();
        wrapper.Lqi = updateStatus.getLqi();
        wrapper.TransmissionTime = updateStatus.getTransmissionTime();
        wrapper.RetriesLeft = updateStatus.getRetriesLeft();
        wrapper.LastChangedAt = updateStatus.getUpdatedAt() != null ? updateStatus.getUpdatedAt().toDate() : null;
        wrapper.finished = updateStatus.getStatus().isSuccessful() || updateStatus.getStatus().isFinished() && updateStatus.getRetriesLeft() == 0;
        wrapper.CreatedAt = updateStatus.getCreatedAt().toDate();
        wrapper.RetriesValidUntil = updateStatus.getRetriesValidUntil() != null ? updateStatus.getRetriesValidUntil().toDate() : null;
        return wrapper;
    }

    public static ESLUpdateStatus newExample() {
        ESLUpdateStatus example = new ESLUpdateStatus();
        example.id = UUID.randomUUID();
        example.LabelId = "B3001634";
        example.TaskType = at.mrdevelopment.esl.tasks.TaskType.IMAGE;
        example.Page = 0;
        example.TaskPriority = at.mrdevelopment.esl.updatetask.TaskPriority.HIGH;
        example.ExternalId = 200202392L;
        example.TransactionId = 5401L;
        example.Status = at.mrdevelopment.esl.core.Status.FAILED;
        example.ErrorCode = null;
        example.ErrorDescription = null;
        example.AccessPointId = 10078;
        example.PowerStatus = at.mrdevelopment.esl.core.PowerStatus.GOOD;
        example.Rssi = -76;
        example.Lqi = 24;
        example.TransmissionTime = 840;
        example.RetriesLeft = 4;
        example.LastChangedAt = new Date();
        example.finished = false;
        example.CreatedAt = new Date();
        example.RetriesValidUntil = new Date();
        return example;
    }
}

