/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.persistence.record.TransactionStatusInfo;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="TransactionStatusInfo")
@XmlRootElement(name="TransactionStatusInfo")
public class ESLTransactionStatusInfo {
    @XmlAttribute(required=true)
    public long id;
    @XmlAttribute(required=true)
    public boolean finished;
    @XmlAttribute(required=true)
    public boolean failed;
    @XmlElement
    public String Title;
    @XmlElement
    public Long ExternalId;
    @XmlElement(required=true)
    public int TotalUpdates;
    @XmlElement(required=true)
    public int FinishedUpdates;
    @XmlElement(required=true)
    public int ErrorUpdates;
    @XmlElement(required=true)
    public Date StartedTime;
    @XmlElement(required=true)
    public Date LastUpdateTime;

    public static ESLTransactionStatusInfo wrap(TransactionStatusInfo transactionStatus) throws MappingException {
        return ESLWrapper.wrap(transactionStatus, TransactionStatusInfo.class, ESLTransactionStatusInfo.class);
    }

    public static ESLTransactionStatusInfo fromTransactionStatusInfo(TransactionStatusInfo transactionStatus) {
        ESLTransactionStatusInfo wrapper = new ESLTransactionStatusInfo();
        wrapper.id = transactionStatus.getId();
        wrapper.finished = transactionStatus.isFinished();
        wrapper.failed = transactionStatus.isFailed();
        wrapper.Title = transactionStatus.getTitle();
        wrapper.ExternalId = transactionStatus.getExternalId();
        wrapper.TotalUpdates = transactionStatus.getTotalUpdates();
        wrapper.FinishedUpdates = transactionStatus.getFinishedUpdates();
        wrapper.ErrorUpdates = transactionStatus.getErrorUpdates();
        wrapper.StartedTime = transactionStatus.getStartedTime().toDate();
        wrapper.LastUpdateTime = transactionStatus.getLastUpdateTime().toDate();
        return wrapper;
    }
}

