/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.TagUtils;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.Tag;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLTagPagedResult;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="Tag")
@XmlRootElement(name="Tag")
public class ESLTag {
    @XmlValue
    public String name;

    public static ESLTagPagedResult wrap(QueryResult<Tag> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, Tag.class, ESLTag.class, ESLTagPagedResult.class);
    }

    public static ESLTag fromTag(Tag tag) {
        ESLTag wrapper = new ESLTag();
        wrapper.name = tag.getName();
        return wrapper;
    }

    public static ESLTag fromTag(String tag) {
        ESLTag wrapper = new ESLTag();
        wrapper.name = tag;
        return wrapper;
    }

    public static List<ESLTag> fromTags(Set<String> tags) {
        return Lists.newArrayList((Iterable)Iterables.transform(tags, (Function)new Function<String, ESLTag>(){

            public ESLTag apply(String tag) {
                return ESLTag.fromTag(tag);
            }
        }));
    }

    public static ESLTag newExample() {
        ESLTag example = new ESLTag();
        example.name = "BEVERAGES";
        return example;
    }

    public static Set<String> toStringSet(List<ESLTag> tags) {
        if (tags == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Iterable)Iterables.transform(tags, (Function)new Function<ESLTag, String>(){

            public String apply(ESLTag tag) {
                return TagUtils.toTag((String)tag.name);
            }
        }));
    }
}

