/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.type.wrapper.element.ESLServiceStatusProperty;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="ServiceStatus")
@XmlRootElement(name="ServiceStatus")
public class ESLServiceStatus {
    @XmlAttribute(required=true)
    public String ServiceName;
    @XmlAttribute
    public String StoreId;
    @XmlElement(name="Property", required=true)
    public List<ESLServiceStatusProperty> Property;

    public static ESLServiceStatus fromServiceStatus(ServiceStatus serviceStatus) {
        Map properties = serviceStatus.getProperties();
        ESLServiceStatus wrapper = new ESLServiceStatus();
        wrapper.ServiceName = serviceStatus.getServiceName();
        wrapper.StoreId = Strings.emptyToNull((String)Config.getStoreId());
        wrapper.Property = new ArrayList<ESLServiceStatusProperty>(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            ESLServiceStatusProperty property = new ESLServiceStatusProperty();
            property.Key = (String)entry.getKey();
            property.Value = (String)entry.getValue();
            wrapper.Property.add(property);
        }
        return wrapper;
    }

    public static ESLServiceStatus newExample() {
        ESLServiceStatus serviceStatus = new ESLServiceStatus();
        serviceStatus.StoreId = "1000";
        serviceStatus.Property = new ArrayList<ESLServiceStatusProperty>();
        serviceStatus.Property.add(ESLServiceStatusProperty.newExample());
        return serviceStatus;
    }
}

