/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.problem.QueryProblem;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.persistence.record.ArticleRecord;
import at.mrdevelopment.esl.persistence.record.MatchingRecord;
import at.mrdevelopment.toolkit.problem.Problem;
import at.mrdevelopment.toolkit.problem.ProblemSeverity;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="Problem")
@XmlRootElement(name="Problem")
public class ESLProblem {
    @XmlAttribute(required=true)
    public String Identifier;
    @XmlAttribute(required=true)
    public ProblemSeverity Severity;
    @XmlAttribute
    public String QueryUrl;
    @XmlAttribute
    public String ResultType;
    @XmlValue
    public String Message;

    public static ESLProblem fromProblem(Problem problem) {
        ESLProblem wrapper = new ESLProblem();
        wrapper.Identifier = problem.getIdentifier();
        wrapper.Severity = problem.getSeverity();
        wrapper.Message = problem.getMessage();
        if (problem instanceof QueryProblem) {
            QueryProblem queryProblem = (QueryProblem)problem;
            wrapper.QueryUrl = queryProblem.getQueryUrl();
            wrapper.ResultType = ESLProblem.getResultType(queryProblem.getRecordClass());
        }
        return wrapper;
    }

    public static ESLProblem newExample() {
        ESLProblem example = new ESLProblem();
        example.Identifier = "access-point-offline";
        example.Severity = ProblemSeverity.ERROR;
        example.QueryUrl = "accesspointinfo/status/offline";
        example.ResultType = "AccessPoint";
        example.Message = "1 offline access point(s)";
        return example;
    }

    private static String getResultType(Class<?> recordClass) {
        if (recordClass == AccessPointInfo.class) {
            return "AccessPoint";
        }
        if (recordClass == ArticleRecord.class) {
            return "Article";
        }
        if (recordClass == MatchingRecord.class) {
            return "Matching";
        }
        return recordClass.getSimpleName();
    }
}

