/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.MatchingRecord;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Matching;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLMatchingPagedResult;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Matching")
@XmlRootElement(name="Matching")
public class ESLMatching {
    @XmlAttribute
    public String label;
    @XmlAttribute
    public String articleNumber;
    @XmlAttribute
    public String template;

    public static ESLMatching wrap(Matching matching) throws MappingException {
        return ESLWrapper.wrap(matching, Matching.class, ESLMatching.class);
    }

    public static ESLMatchingPagedResult wrap(QueryResult<Matching> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, Matching.class, ESLMatching.class, ESLMatchingPagedResult.class);
    }

    public static ESLMatching fromMatchingRecord(MatchingRecord matchingRecord) {
        return ESLMatching.fromMatching(matchingRecord.toMatching());
    }

    public static ESLMatching fromMatching(Matching matching) {
        ESLMatching wrapper = new ESLMatching();
        wrapper.label = matching.getLabelId().getLabelIdString();
        wrapper.articleNumber = matching.getArticleNumbersString();
        wrapper.template = matching.getTemplate();
        return wrapper;
    }

    public static ESLMatching newExample() {
        ESLMatching example = new ESLMatching();
        example.label = "B30013B7";
        example.articleNumber = "1234567";
        example.template = "default.xsl";
        return example;
    }

    public ESLMatching(String label, String articleNumber, String template) {
        this.label = label;
        this.articleNumber = articleNumber;
        this.template = template;
    }

    public ESLMatching() {
    }

    public Matching toMatching() throws SerializeException {
        LabelId labelId = LabelId.fromString((String)this.label);
        Collection articleNumbers = ArticleNumber.fromMultiString((String)this.articleNumber);
        return new Matching(labelId, articleNumbers, this.template);
    }
}

