/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.persistence.query.LoggingQuery;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLLoggingEntryPagedResult;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LoggingEntry")
@XmlRootElement(name="LoggingEntry")
public class ESLLoggingEntry {
    @XmlAttribute
    public Date time;
    @XmlAttribute
    public String logger;
    @XmlAttribute
    public String level;
    @XmlAttribute
    public String message;

    public static ESLLoggingEntryPagedResult wrap(QueryResult<LoggingQuery.Logging> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, LoggingQuery.Logging.class, ESLLoggingEntry.class, ESLLoggingEntryPagedResult.class);
    }

    public static ESLLoggingEntry fromLogging(LoggingQuery.Logging logging) {
        ESLLoggingEntry wrapper = new ESLLoggingEntry();
        wrapper.logger = logging.getLogger();
        wrapper.level = logging.getLevel();
        wrapper.time = logging.getTime().toDate();
        wrapper.message = logging.getMessage();
        return wrapper;
    }

    public static ESLLoggingEntry newExample() {
        ESLLoggingEntry example = new ESLLoggingEntry();
        example.logger = "Logger";
        example.level = "WARN";
        example.message = "Warning!";
        example.time = new Date();
        return example;
    }
}

