/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.DefaultLabelTypeMapping;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LabelType")
@XmlRootElement(name="LabelType")
public class ESLLabelType {
    private static final DefaultLabelTypeMapping mapping = DefaultLabelTypeMapping.INSTANCE;
    @XmlElement(required=true)
    public String Name;
    public int PageCount;
    public int RegistrationPage;
    public int ResetPage;
    public int DisplayWidth;
    public int DisplayHeight;
    public String DisplayColors;
    public int Orientation;
    @XmlElement(name="Code")
    public List<String> labelCodes;

    public static ESLLabelType fromLabelId(LabelId labelId) {
        LabelType typeForLabelId = mapping.getTypeForLabelId(labelId.getId());
        return ESLLabelType.fromLabelType(typeForLabelId);
    }

    public static ESLLabelType fromLabelType(LabelType labelType) {
        ESLLabelType type = new ESLLabelType();
        type.Name = labelType.getName();
        type.PageCount = labelType.getAvailablePageCount();
        type.RegistrationPage = labelType.getRegistrationPage().getPageIndex();
        type.ResetPage = labelType.getResetPage().getPageIndex();
        type.DisplayWidth = labelType.getDisplayWidth();
        type.DisplayHeight = labelType.getDisplayHeight();
        type.DisplayColors = labelType.getDisplayColors().name();
        type.Orientation = labelType.getImageRotation();
        type.labelCodes = Lists.newArrayList((Iterable)Collections2.transform((Collection)DefaultLabelTypeMapping.getCodesForType((LabelType)labelType), (Function)new Function<Integer, String>(){

            public String apply(Integer code) {
                return Integer.toHexString(code).toUpperCase();
            }
        }));
        return type;
    }

    public static ESLLabelType newExample() {
        return ESLLabelType.fromLabelType(LabelType.BATTERY_270);
    }
}

