/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.esl.labelstatistics.StatisticCategory;
import at.mrdevelopment.toolkit.text.PercentageFormatter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LabelStatistics")
@XmlRootElement(name="LabelStatistics")
public class ESLLabelStatistics {
    @XmlAttribute
    public String category;
    @XmlAttribute
    public String identifier;
    @XmlAttribute
    public String description;
    @XmlAttribute
    public String count;
    @XmlAttribute
    public String percentage;

    public static ESLLabelStatistics fromLabelStatistics(LabelStatistics labelStatistics) {
        ESLLabelStatistics wrapper = new ESLLabelStatistics();
        wrapper.category = labelStatistics.getCategory().getIdentifier();
        wrapper.identifier = labelStatistics.getIdentifier();
        wrapper.description = labelStatistics.getDescription();
        wrapper.count = Integer.toString(labelStatistics.getCount());
        wrapper.percentage = PercentageFormatter.format((int)labelStatistics.getCount(), (int)labelStatistics.getTotalLabels());
        return wrapper;
    }

    public static ESLLabelStatistics newExample() {
        ESLLabelStatistics example = new ESLLabelStatistics();
        example.category = StatisticCategory.CONNECTION_STATUS.getIdentifier();
        example.identifier = String.format("%s.%s", StatisticCategory.CONNECTION_STATUS.getIdentifier(), ConnectionStatus.ONLINE.toString());
        example.description = String.format("%s - %s", StatisticCategory.CONNECTION_STATUS.getDescription(), ConnectionStatus.ONLINE.getDescription());
        example.count = "5";
        example.percentage = "100";
        return example;
    }
}

