/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.LabelInfoHistoryRecord;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelInfoHistoryPagedResult;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LabelInfoHistory")
@XmlRootElement(name="LabelInfoHistory")
public class ESLLabelInfoHistory {
    @XmlElement(required=true)
    public String LabelId;
    public String FirmwareVersion;
    public SecurityStatus SecurityStatus;
    public Integer CurrentPage;
    public PowerStatus InternalPowerStatus;
    public Integer LabelErrors;
    public Integer SyncQuality;
    public Integer Rssi;
    public Integer Lqi;
    public Integer AccessPointId;
    public Date WakeUpTime;
    public ConnectionStatus ConnectionStatus;
    public PowerStatus CalculatedPowerStatus;
    public Date CalculatedPowerStatusTimestamp;
    public Date UpdatedAt;

    public static ESLLabelInfoHistoryPagedResult wrap(QueryResult<LabelInfoHistoryRecord> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, LabelInfoHistoryRecord.class, ESLLabelInfoHistory.class, ESLLabelInfoHistoryPagedResult.class);
    }

    public static ESLLabelInfoHistory fromLabelInfoHistoryRecord(LabelInfoHistoryRecord labelInfoHistoryRecord) {
        ESLLabelInfoHistory wrapper = new ESLLabelInfoHistory();
        wrapper.LabelId = labelInfoHistoryRecord.getLabelIdString();
        wrapper.FirmwareVersion = labelInfoHistoryRecord.getFirmwareVersion();
        wrapper.SecurityStatus = labelInfoHistoryRecord.getSecurityStatus();
        wrapper.CurrentPage = labelInfoHistoryRecord.getCurrentPage();
        wrapper.InternalPowerStatus = labelInfoHistoryRecord.getInternalPowerStatus();
        wrapper.LabelErrors = labelInfoHistoryRecord.getLabelErrors();
        wrapper.SyncQuality = labelInfoHistoryRecord.getSyncQuality();
        wrapper.Rssi = labelInfoHistoryRecord.getRssi();
        wrapper.Lqi = labelInfoHistoryRecord.getLqi();
        wrapper.AccessPointId = labelInfoHistoryRecord.getAccessPointId();
        wrapper.WakeUpTime = labelInfoHistoryRecord.getWakeupTime() != null ? labelInfoHistoryRecord.getWakeupTime().toDate() : null;
        wrapper.ConnectionStatus = labelInfoHistoryRecord.getConnectionStatus();
        wrapper.CalculatedPowerStatus = labelInfoHistoryRecord.getCalculatedPowerStatus();
        wrapper.CalculatedPowerStatusTimestamp = labelInfoHistoryRecord.getCalculatedPowerStatusTimestamp() != null ? labelInfoHistoryRecord.getCalculatedPowerStatusTimestamp().toDate() : null;
        wrapper.UpdatedAt = labelInfoHistoryRecord.getUpdatedAt() != null ? labelInfoHistoryRecord.getUpdatedAt().toDate() : null;
        return wrapper;
    }

    public static ESLLabelInfoHistory newExample() {
        ESLLabelInfoHistory example = new ESLLabelInfoHistory();
        example.LabelId = "B1001C4A";
        example.FirmwareVersion = "3.0.0";
        example.SecurityStatus = at.mrdevelopment.esl.core.SecurityStatus.AES128;
        example.CurrentPage = 0;
        example.InternalPowerStatus = PowerStatus.GOOD;
        example.LabelErrors = 0;
        example.SyncQuality = 255;
        example.Rssi = -61;
        example.Lqi = 37;
        example.AccessPointId = 10323;
        example.WakeUpTime = new Date();
        example.ConnectionStatus = at.mrdevelopment.esl.core.ConnectionStatus.ONLINE;
        example.CalculatedPowerStatus = PowerStatus.GOOD;
        example.CalculatedPowerStatusTimestamp = new Date();
        example.UpdatedAt = new Date();
        return example;
    }
}

