/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLTag;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelInfoPagedResult;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LabelInfo")
@XmlRootElement(name="LabelInfo")
public class ESLLabelInfo {
    @XmlElement(required=true)
    public String LabelId;
    public String Type;
    @XmlElement(name="Tag")
    public List<ESLTag> Tags;
    public Date WakeupTime;
    public String FirmwareVersion;
    public SecurityStatus SecurityStatus;
    public PowerStatus PowerStatus;
    public Integer SyncQuality;
    public Integer LabelErrors;
    public String CurrentPage;
    public Integer Rssi;
    public Integer Lqi;
    public Integer AccessPointId;
    public ConnectionStatus ConnectionStatus;
    public UUID TaskId;
    public TaskType TaskType;
    public Integer Page;
    public Status Status;
    public Integer ErrorCode;
    public Date UpdatedAt;

    public static ESLLabelInfo wrap(LabelInfo labelInfo) throws MappingException {
        return ESLWrapper.wrap(labelInfo, LabelInfo.class, ESLLabelInfo.class);
    }

    public static ESLLabelInfoPagedResult wrap(List<LabelInfo> labelInfos) throws MappingException {
        return ESLWrapper.wrap(labelInfos, LabelInfo.class, ESLLabelInfo.class, ESLLabelInfoPagedResult.class);
    }

    public static ESLLabelInfoPagedResult wrap(QueryResult<LabelInfo> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, LabelInfo.class, ESLLabelInfo.class, ESLLabelInfoPagedResult.class);
    }

    public static ESLLabelInfo fromLabelInfo(LabelInfo labelInfo) {
        ESLLabelInfo wrapper = new ESLLabelInfo();
        wrapper.LabelId = labelInfo.getLabelIdString();
        wrapper.Type = labelInfo.getType();
        wrapper.Tags = ESLTag.fromTags(labelInfo.getTags());
        wrapper.ConnectionStatus = labelInfo.getConnectionStatus();
        wrapper.PowerStatus = labelInfo.getPowerStatus();
        wrapper.WakeupTime = labelInfo.getWakeupTime() != null ? labelInfo.getWakeupTime().toDate() : null;
        wrapper.TaskId = labelInfo.getTaskId();
        wrapper.TaskType = labelInfo.getTaskType();
        wrapper.Page = labelInfo.getPage();
        wrapper.Status = labelInfo.getStatus();
        wrapper.ErrorCode = labelInfo.getUpdateErrorCode();
        wrapper.UpdatedAt = labelInfo.getLastUpdateTime() != null ? labelInfo.getLastUpdateTime().toDate() : null;
        wrapper.FirmwareVersion = labelInfo.getFirmwareVersion() != null ? labelInfo.getFirmwareVersion().getVersionString() : null;
        wrapper.SecurityStatus = labelInfo.getSecurityStatus() != null ? labelInfo.getSecurityStatus() : null;
        wrapper.SyncQuality = labelInfo.getSyncQuality() != null ? Integer.valueOf(labelInfo.getSyncQuality().getSyncQualityValue()) : null;
        wrapper.LabelErrors = labelInfo.getLabelErrors() != null ? Integer.valueOf(labelInfo.getLabelErrors().getErrorCode()) : null;
        wrapper.CurrentPage = labelInfo.getCurrentPage() != null ? labelInfo.getCurrentPage().getPageString() : null;
        wrapper.Rssi = labelInfo.getRssi();
        wrapper.Lqi = labelInfo.getLqi();
        wrapper.AccessPointId = labelInfo.getAccessPointId();
        return wrapper;
    }

    public static ESLLabelInfo newExample() {
        ESLLabelInfo example = new ESLLabelInfo();
        example.LabelId = "B1001C4A";
        example.Type = LabelType.BATTERY_270.getName();
        example.Tags = Lists.newArrayList((Object[])new ESLTag[]{ESLTag.newExample()});
        example.ConnectionStatus = at.mrdevelopment.esl.core.ConnectionStatus.ONLINE;
        example.PowerStatus = at.mrdevelopment.esl.core.PowerStatus.GOOD;
        example.WakeupTime = new Date();
        example.TaskId = UUID.randomUUID();
        example.TaskType = at.mrdevelopment.esl.tasks.TaskType.PING;
        example.Status = at.mrdevelopment.esl.core.Status.SUCCESSFUL;
        example.UpdatedAt = new Date();
        example.FirmwareVersion = "3.0.0";
        example.SecurityStatus = at.mrdevelopment.esl.core.SecurityStatus.AES128;
        example.SyncQuality = 255;
        example.LabelErrors = 0;
        example.CurrentPage = "0";
        example.Rssi = -61;
        example.Lqi = 37;
        example.AccessPointId = 10323;
        return example;
    }
}

