/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLLabelEventPagedResult;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LabelEvent")
@XmlRootElement(name="LabelEvent")
public class ESLLabelEvent {
    @XmlAttribute(required=true)
    public UUID id;
    @XmlElement(required=true)
    public String LabelId;
    public Integer Type;
    public Integer Data;
    public Date ReceivedTime;
    @XmlElement(required=false)
    public boolean Confirmed;

    public static ESLLabelEvent wrap(LabelEvent labelEvent) throws MappingException {
        return ESLWrapper.wrap(labelEvent, LabelEvent.class, ESLLabelEvent.class);
    }

    public static ESLLabelEventPagedResult wrap(List<LabelEvent> labelEvents) throws MappingException {
        return ESLWrapper.wrap(labelEvents, LabelEvent.class, ESLLabelEvent.class, ESLLabelEventPagedResult.class);
    }

    public static ESLLabelEventPagedResult wrapPaged(int page, int recordsPerPage, int totalRecords, List<LabelEvent> labelEvents) throws MappingException {
        QueryResult queryResult = QueryResult.newPagedResult(labelEvents, (int)totalRecords, (int)page, (int)recordsPerPage);
        return ESLWrapper.wrapPaged(queryResult, LabelEvent.class, ESLLabelEvent.class, ESLLabelEventPagedResult.class);
    }

    public static ESLLabelEventPagedResult wrap(QueryResult<LabelEvent> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, LabelEvent.class, ESLLabelEvent.class, ESLLabelEventPagedResult.class);
    }

    public static ESLLabelEvent fromLabelEvent(LabelEvent labelEvent) {
        ESLLabelEvent wrapper = new ESLLabelEvent();
        wrapper.id = labelEvent.getEventId();
        wrapper.LabelId = labelEvent.getLabelAddress().toString();
        wrapper.Type = labelEvent.getEventType();
        wrapper.Data = labelEvent.getEventData();
        wrapper.ReceivedTime = labelEvent.getReceivedTime() != null ? labelEvent.getReceivedTime().toDate() : null;
        wrapper.Confirmed = labelEvent.isConfirmed();
        return wrapper;
    }

    public static ESLLabelEvent newExample() {
        ESLLabelEvent example = new ESLLabelEvent();
        example.id = UUID.randomUUID();
        example.LabelId = "B1001C4A";
        example.Type = 1;
        example.Data = 0;
        example.ReceivedTime = new Date();
        return example;
    }
}

