/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.tag.LabelTagsUpdate;
import at.mrdevelopment.esl.type.wrapper.element.ESLTag;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Label")
@XmlRootElement(name="Label")
public class ESLLabel {
    @XmlAttribute(required=true)
    public String id;
    @XmlElement(name="Tag", required=false)
    public List<ESLTag> Tags;

    public static ESLLabel fromString(String id) {
        return new ESLLabel(id);
    }

    public static ESLLabel fromLabelId(LabelId label) {
        return new ESLLabel(label.getLabelIdString());
    }

    public static ESLLabel fromLabelRegistration(LabelRegistration labelRegistration) {
        ESLLabel label = new ESLLabel(labelRegistration.getLabelId().getLabelIdString());
        label.Tags = ESLTag.fromTags(labelRegistration.getTags());
        return label;
    }

    public static ESLLabel newExample() {
        ESLLabel example = new ESLLabel("B1001C4A");
        example.Tags = new ArrayList<ESLTag>();
        example.Tags.add(ESLTag.fromTag("BEVERAGES"));
        example.Tags.add(ESLTag.fromTag("STORE_2033"));
        return example;
    }

    public ESLLabel(String id) {
        this.id = id;
    }

    public ESLLabel() {
    }

    public LabelId toLabelId() throws SerializeException {
        return LabelId.fromString((String)this.id);
    }

    public LabelRegistration toLabelRegistration() throws SerializeException {
        return LabelRegistration.fromRegistrationCodeOrLabelId((String)this.id, ESLTag.toStringSet(this.Tags));
    }

    public LabelTagsUpdate toTagsUpdate(LabelTagsUpdate.Operation operation) throws SerializeException {
        return new LabelTagsUpdate(LabelId.fromString((String)this.id), ESLTag.toStringSet(this.Tags), operation);
    }
}

