/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.type.BasicType;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLConfigurationPagedResult;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Configuration")
@XmlRootElement(name="Configuration")
public class ESLConfiguration {
    @XmlAttribute(required=true)
    public String Key;
    @XmlAttribute
    public BasicType Type;
    @XmlAttribute
    public String DefaultValue;
    @XmlAttribute
    public String Value;

    public static ESLConfiguration wrap(Configuration configuration) throws MappingException {
        return ESLWrapper.wrap(configuration, Configuration.class, ESLConfiguration.class);
    }

    public static ESLConfigurationPagedResult wrap(QueryResult<Configuration> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, Configuration.class, ESLConfiguration.class, ESLConfigurationPagedResult.class);
    }

    public static ESLConfiguration fromConfiguration(Configuration configuration) {
        ESLConfiguration wrapper = new ESLConfiguration();
        wrapper.Key = configuration.getKey();
        wrapper.Type = configuration.getType();
        wrapper.DefaultValue = configuration.getDefaultValue();
        wrapper.Value = configuration.getValue();
        return wrapper;
    }

    public static ESLConfiguration newExample() {
        ESLConfiguration example = new ESLConfiguration();
        example.Key = "transmissionRetriesCount";
        example.Type = BasicType.INTEGER;
        example.DefaultValue = "5";
        example.Value = "3";
        return example;
    }

    public Configuration toConfiguration() {
        return new Configuration(this.Key, this.Type, this.DefaultValue, this.Value);
    }
}

