/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.ArticleRecord;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLArticleField;
import at.mrdevelopment.esl.type.wrapper.list.ESLArticlePagedResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Article")
@XmlRootElement(name="Article")
public class ESLArticle {
    @XmlAttribute
    public String articleNumber;
    @XmlElement(name="Gtin")
    public Set<Long> Gtins;
    @XmlElement(name="Field")
    public Set<ESLArticleField> Fields;

    public static ESLArticlePagedResult wrap(QueryResult<Article> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, Article.class, ESLArticle.class, ESLArticlePagedResult.class);
    }

    public static ESLArticle fromArticleRecord(ArticleRecord articleRecord) {
        return ESLArticle.fromArticle(articleRecord.toArticle());
    }

    public static ESLArticle fromArticle(Article article) {
        ESLArticle wrapper = new ESLArticle();
        wrapper.articleNumber = article.getArticleNumber().toString();
        wrapper.Gtins = new HashSet<Long>();
        wrapper.Fields = new HashSet<ESLArticleField>();
        for (Gtin gtin : article.getGtins()) {
            wrapper.Gtins.add(gtin.toLong());
        }
        for (Map.Entry entry : article.getValues().entrySet()) {
            wrapper.Fields.add(new ESLArticleField((String)entry.getKey(), (String)entry.getValue()));
        }
        return wrapper;
    }

    public static ESLArticle newExample() {
        ESLArticle example = new ESLArticle();
        example.articleNumber = "1234567";
        example.Gtins = new HashSet<Long>();
        example.Fields = new HashSet<ESLArticleField>();
        example.Gtins.add(5449000000996L);
        example.Gtins.add(7610700606681L);
        ESLArticleField nameField = new ESLArticleField();
        nameField.key = "name";
        nameField.value = "Coca Cola";
        example.Fields.add(nameField);
        ESLArticleField descriptionField = new ESLArticleField();
        descriptionField.key = "description";
        descriptionField.value = "Dose 0.33 l";
        example.Fields.add(descriptionField);
        ESLArticleField priceField = new ESLArticleField();
        priceField.key = "price";
        priceField.value = "0.69";
        example.Fields.add(priceField);
        ESLArticleField saleField = new ESLArticleField();
        saleField.key = "sale";
        saleField.value = "1";
        example.Fields.add(saleField);
        return example;
    }

    public Article toArticle() {
        ArticleNumber articleNumber = ArticleNumber.fromString((String)this.articleNumber);
        HashSet<Gtin> gtins = new HashSet<Gtin>();
        HashMap<String, String> fields = new HashMap<String, String>();
        if (this.Gtins != null) {
            Iterator<Object> i$ = this.Gtins.iterator();
            while (i$.hasNext()) {
                long gtin = (Long)i$.next();
                gtins.add(Gtin.fromLong((long)gtin));
            }
        }
        if (this.Fields != null) {
            for (ESLArticleField field : this.Fields) {
                fields.put(field.key, field.value);
            }
        }
        return new Article(articleNumber, gtins, fields);
    }

    public ArticleNumber toArticleNumber() {
        return ArticleNumber.fromString((String)this.articleNumber);
    }
}

