/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.AccessPointRegistration;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.element.ESLAccessPointConfiguration;
import at.mrdevelopment.esl.type.wrapper.list.ESLAccessPointRegistrationPagedResult;
import java.net.MalformedURLException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;

@XmlType(name="AccessPointRegistration")
@XmlRootElement(name="AccessPointRegistration")
public class ESLAccessPointRegistration {
    public int AccessPointId;
    public String ServiceAddress;
    @XmlElement(name="AccessPointConfiguration")
    public ESLAccessPointConfiguration AccessPointConfiguration;

    public static ESLAccessPointRegistrationPagedResult wrap(QueryResult<AccessPointConfiguration> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, AccessPointConfiguration.class, ESLAccessPointRegistration.class, ESLAccessPointRegistrationPagedResult.class);
    }

    public static ESLAccessPointRegistration fromAccessPointConfiguration(AccessPointConfiguration accessPointConfiguration) {
        ESLAccessPointRegistration wrapper = new ESLAccessPointRegistration();
        wrapper.AccessPointId = accessPointConfiguration.getAccessPointId();
        wrapper.ServiceAddress = accessPointConfiguration.getServiceAddress() != null ? accessPointConfiguration.getServiceAddress().toString() : null;
        wrapper.AccessPointConfiguration = ESLAccessPointConfiguration.fromAccessPointConfiguration(accessPointConfiguration);
        return wrapper;
    }

    public static ESLAccessPointRegistration newExample() {
        ESLAccessPointRegistration example = new ESLAccessPointRegistration();
        example.AccessPointId = 10078;
        example.ServiceAddress = "http://192.168.1.200:8080/";
        example.AccessPointConfiguration = ESLAccessPointConfiguration.newExample();
        return example;
    }

    public AccessPointRegistration toAccessPointRegistration() throws MalformedURLException {
        ServiceAddress serviceAddress = null;
        if (StringUtils.isNotBlank((String)this.ServiceAddress)) {
            serviceAddress = at.mrdevelopment.esl.core.ServiceAddress.fromStringFor((String)this.ServiceAddress, (AccessPointType)AccessPointTypeMapping.getType((int)this.AccessPointId));
        }
        AccessPointRegistration.Configuration configuration = this.AccessPointConfiguration != null ? this.AccessPointConfiguration.toAccessPointRegistrationConfiguration() : new AccessPointRegistration.Configuration();
        return new AccessPointRegistration(this.AccessPointId, serviceAddress, configuration);
    }
}

