/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.AccessPointRegistration;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="AccessPointConfiguration")
@XmlRootElement(name="AccessPointConfiguration")
public class ESLAccessPointConfiguration {
    public String HostName;
    public String StaticIpAddress;
    public String SubnetMask;
    public String Gateway;
    public String Dns;
    public Integer Channel;

    public static ESLAccessPointConfiguration fromAccessPointConfiguration(AccessPointConfiguration accessPointConfiguration) {
        ESLAccessPointConfiguration wrapper = new ESLAccessPointConfiguration();
        if (accessPointConfiguration.isAutoConfig()) {
            wrapper.HostName = accessPointConfiguration.getHostName();
            wrapper.StaticIpAddress = accessPointConfiguration.getAddress();
            wrapper.SubnetMask = accessPointConfiguration.getSubnetMask();
            wrapper.Gateway = accessPointConfiguration.getGateway();
            wrapper.Dns = accessPointConfiguration.getDns();
            wrapper.Channel = accessPointConfiguration.getChannel() != null ? Integer.valueOf(accessPointConfiguration.getChannel().getChannelId()) : null;
            return wrapper;
        }
        return null;
    }

    public static ESLAccessPointConfiguration newExample() {
        ESLAccessPointConfiguration example = new ESLAccessPointConfiguration();
        example.HostName = "ap-office";
        example.StaticIpAddress = "192.168.1.200";
        example.SubnetMask = "255.255.255.0";
        example.Gateway = "192.168.1.1";
        example.Dns = "192.168.1.1";
        example.Channel = 9;
        return example;
    }

    public AccessPointRegistration.Configuration toAccessPointRegistrationConfiguration() {
        return new AccessPointRegistration.Configuration(this.HostName, this.StaticIpAddress, this.SubnetMask, this.Gateway, this.Dns, this.Channel != null ? WirelessChannel.getFromId((int)this.Channel) : null);
    }
}

