/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper.element;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.type.wrapper.ESLWrapper;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLAccessPointPagedResult;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="AccessPoint")
@XmlRootElement(name="AccessPoint")
public class ESLAccessPoint {
    public String Name;
    public int AccessPointId;
    public String Address;
    public Integer Channel;
    public ConnectionStatus ConnectionStatus;
    public String Version;
    public Date UpdateTime;
    public Boolean AutoConfig;
    public String Protocol;
    public String Type;
    public String ManagementAddress;

    public static ESLAccessPointPagedResult wrap(QueryResult<AccessPointInfo> queryResult) throws MappingException {
        return ESLWrapper.wrapPaged(queryResult, AccessPointInfo.class, ESLAccessPoint.class, ESLAccessPointPagedResult.class);
    }

    public static ESLAccessPoint fromAccessPointInfo(AccessPointInfo accessPointInfo) {
        ESLAccessPoint wrapper = new ESLAccessPoint();
        wrapper.Name = accessPointInfo.getName();
        wrapper.AccessPointId = accessPointInfo.getAccessPointId();
        wrapper.Address = accessPointInfo.getAddress();
        wrapper.Channel = accessPointInfo.getChannel() != null ? Integer.valueOf(accessPointInfo.getChannel().getChannelId()) : null;
        wrapper.ConnectionStatus = accessPointInfo.getConnectionStatus();
        wrapper.Version = accessPointInfo.getVersion() != null ? accessPointInfo.getVersion().toString() : null;
        wrapper.UpdateTime = accessPointInfo.getUpdateTime() != null ? accessPointInfo.getUpdateTime().toDate() : null;
        wrapper.AutoConfig = accessPointInfo.getAutoConfig();
        wrapper.Protocol = accessPointInfo.getProtocol();
        wrapper.Type = accessPointInfo.getTypeIdentifier() != null ? accessPointInfo.getTypeIdentifier() : null;
        wrapper.ManagementAddress = accessPointInfo.getManagementAddress();
        return wrapper;
    }

    public static ESLAccessPoint newExample() {
        ESLAccessPoint example = new ESLAccessPoint();
        example.Name = "imagotag-ap";
        example.AccessPointId = 10078;
        example.Address = "http://192.168.1.1:8080";
        example.ConnectionStatus = at.mrdevelopment.esl.core.ConnectionStatus.ONLINE;
        example.Channel = 9;
        example.Version = "1.1.0";
        example.UpdateTime = new Date();
        example.AutoConfig = false;
        example.Protocol = "HTTP/HTTPS";
        example.Type = AccessPointType.IMAGOTAG.name();
        example.ManagementAddress = "http://192.168.1.1:8080";
        return example;
    }
}

