/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type.wrapper;

import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.wrapper.MappingException;
import at.mrdevelopment.esl.type.wrapper.list.ESLPagedResult;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ESLWrapper {
    public static <B, W> W wrap(B element, Class<B> baseClass, Class<W> wrapperClass) throws MappingException {
        try {
            Method method = wrapperClass.getMethod("from" + baseClass.getSimpleName(), baseClass);
            W wrappedElement = wrapperClass.cast(method.invoke(null, element));
            return wrappedElement;
        }
        catch (Exception exc) {
            throw new MappingException(baseClass, (Throwable)exc);
        }
    }

    public static <B, W, L> L wrap(Collection<B> list, Class<B> baseClass, Class<W> wrapperClass, Class<L> wrapperListClass) throws MappingException {
        try {
            Method method = wrapperClass.getMethod("from" + baseClass.getSimpleName(), baseClass);
            L wrapperList = wrapperListClass.newInstance();
            Field wrapperListField = wrapperListClass.getField("List");
            ArrayList<W> wrapperListInstance = new ArrayList<W>();
            wrapperListField.set(wrapperList, wrapperListInstance);
            for (B element : list) {
                W wrappedElement = wrapperClass.cast(method.invoke(null, element));
                wrapperListInstance.add(wrappedElement);
            }
            return wrapperList;
        }
        catch (Exception exc) {
            throw new MappingException(baseClass, (Throwable)exc);
        }
    }

    public static <B, W> List<W> wrap(Collection<B> list, Class<B> baseClass, Class<W> wrapperClass) throws MappingException {
        try {
            Method method = wrapperClass.getMethod("from" + baseClass.getSimpleName(), baseClass);
            ArrayList<W> wrapperList = new ArrayList<W>();
            for (B element : list) {
                W wrappedElement = wrapperClass.cast(method.invoke(null, element));
                wrapperList.add(wrappedElement);
            }
            return wrapperList;
        }
        catch (Exception exc) {
            throw new MappingException(baseClass, (Throwable)exc);
        }
    }

    public static <B, W, L extends ESLPagedResult> L wrapPaged(QueryResult<B> queryResult, Class<B> baseClass, Class<W> wrapperClass, Class<L> wrapperListClass) throws MappingException {
        try {
            Method method = wrapperClass.getMethod("from" + baseClass.getSimpleName(), baseClass);
            ESLPagedResult pagedResult = (ESLPagedResult)wrapperListClass.newInstance();
            Field wrapperListField = wrapperListClass.getField("List");
            ArrayList<W> wrapperListInstance = new ArrayList<W>();
            wrapperListField.set(pagedResult, wrapperListInstance);
            for (Object element : queryResult.getRecords()) {
                W wrappedElement = wrapperClass.cast(method.invoke(null, element));
                wrapperListInstance.add(wrappedElement);
            }
            pagedResult.records = queryResult.getRecords().size();
            pagedResult.totalRecords = queryResult.getTotalRecords();
            pagedResult.totalPages = queryResult.getTotalPages();
            pagedResult.page = queryResult.getPage();
            pagedResult.recordsPerPage = queryResult.getRecordsPerPage();
            return (L)pagedResult;
        }
        catch (Exception exc) {
            throw new MappingException(baseClass, (Throwable)exc);
        }
    }
}

