/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.websocket;

import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.custom.level2.Level2Connector;
import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.custom.websocket.ArticleWebSocketApplication;
import at.mrdevelopment.esl.type.Matching;
import at.mrdevelopment.esl.type.UpdateResult;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class WebSocketConnector
implements Level2Connector {
    static ESLLogger logger = ESLLogger.getLogger(WebSocketConnector.class);
    private final HttpServer httpServer;
    private final ArticleWebSocketApplication application;

    public WebSocketConnector(Level2Interface eslInterface) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        logger.info("Starting Grizzly Webserver");
        WebSocketAddOn addOn = new WebSocketAddOn();
        this.httpServer = HttpServer.createSimpleServer((String)"/esl", (int)8010);
        for (NetworkListener listener : this.httpServer.getListeners()) {
            listener.registerAddOn((AddOn)addOn);
        }
        this.application = new ArticleWebSocketApplication(eslInterface);
        WebSocketEngine.getEngine().register((WebSocketApplication)this.application);
    }

    public void run() {
    }

    public void cleanup(int daysToKeep) {
    }

    public void shutdown() {
        logger.info("Stopping Grizzly Webserver");
        WebSocketEngine.getEngine().unregister((WebSocketApplication)this.application);
        this.httpServer.stop();
    }

    public void notifyUpdateFinished(UpdateResult updateResult) {
    }

    public void notifyMatchingModified(Matching matching) throws Exception {
    }

    public void notifyLabelStatusChanged() {
    }

    public void notifyLabelEvent(LabelEvent labelEvent) {
    }

    public void notifyEslProblem() {
    }
}

