/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom.websocket;

import at.mrdevelopment.esl.custom.level2.Level2Interface;
import at.mrdevelopment.esl.custom.level2.QueryArticleConnector;
import at.mrdevelopment.esl.custom.websocket.ArticleWebSocket;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class ArticleWebSocketApplication
extends WebSocketApplication {
    static ESLLogger logger = ESLLogger.getLogger(ArticleWebSocketApplication.class);
    private final Level2Interface eslInterface;

    public ArticleWebSocketApplication(Level2Interface eslInterface) {
        this.eslInterface = eslInterface;
    }

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket request, WebSocketListener ... listeners) {
        return new ArticleWebSocket(handler, request, listeners);
    }

    public boolean isApplicationRequest(HttpRequestPacket request) {
        logger.info("Websocket request " + request.toString());
        return "/esl".equals(request.getRequestURI());
    }

    public void onMessage(WebSocket websocket, String data) {
        logger.info("Websocket onMessage " + data);
        try {
            ArticleNumber articleNumber = null;
            this.eslInterface.articleUpdated(articleNumber, 0L);
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    public void onClose(WebSocket websocket, DataFrame frame) {
        logger.info("Closed web socket");
    }

    public Article queryArticle(ArticleNumber articleNumber) {
        return null;
    }

    public Article queryArticle(Gtin gtin) {
        for (WebSocket webSocket : this.getWebSockets()) {
            if (!webSocket.isConnected()) continue;
            try {
                QueryArticleConnector articleSource = (QueryArticleConnector)webSocket;
                return articleSource.queryArticle(gtin);
            }
            catch (Exception exc) {
                logger.logException((Throwable)exc);
            }
        }
        return null;
    }
}

